/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.parallel;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.runtime.async.Future;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.Table;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelCallUtil {
    public static final int MAX_THREAD_LIMIT = 50;

    public static int getMaxThreadCountForParallelCalls() {
        return ServiceFactory.getRuntimeService().getMaxThreadCountForParallelCalls();
    }

    public static List<Future> submitParallelTaskForList(List list, UDFMethod func, boolean passArray, ExecutorService executor) throws CloneNotSupportedException {
        FusionContext originalFusContext = FusionContext.getCurrent();
        originalFusContext.setParallelCall(true);
        ArrayList<Future> futures = new ArrayList<Future>();
        Object item = null;
        for (int i = 0; i < list.size(); ++i) {
            item = list.get(i);
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            Object[] args = null;
            args = passArray ? new Object[]{item, i + 1, list} : new Object[]{item, i + 1};
            CallableUDFMethod callableUDFMethod = new CallableUDFMethod(func, null, args, newFusContext, newPageContext, RequestMonitorData.getCurrent(), true);
            java.util.concurrent.Future<Object> fut = executor.submit(callableUDFMethod);
            Future futureObj = new Future(fut);
            futureObj.setUdfMethodRef(callableUDFMethod);
            futures.add(futureObj);
        }
        originalFusContext.setParallelCall(false);
        return futures;
    }

    public static List<Future> submitParallelTaskForQuery(Object queryObj, UDFMethod func, ExecutorService executor) throws CloneNotSupportedException {
        FusionContext originalFusContext = FusionContext.getCurrent();
        originalFusContext.setParallelCall(true);
        Table query = (Table)queryObj;
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableUDFMethod callableUDFMethod = new CallableUDFMethod(func, null, new Object[]{rowData, i, query}, newFusContext, newPageContext, RequestMonitorData.getCurrent(), true);
            java.util.concurrent.Future<Object> fut = executor.submit(callableUDFMethod);
            Future futureObj = new Future(fut);
            futureObj.setUdfMethodRef(callableUDFMethod);
            futures.add(futureObj);
        }
        originalFusContext.setParallelCall(false);
        return futures;
    }

    public static void submitCallablesForList(List list, UDFMethod udfMethod, CompletionService completionService) throws CloneNotSupportedException {
        FusionContext originalFusContext = FusionContext.getCurrent();
        originalFusContext.setParallelCall(true);
        Object item = null;
        for (int i = 0; i < list.size(); ++i) {
            item = list.get(i);
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableMethod method = new CallableMethod(udfMethod, null, new Object[]{item, i + 1, list}, newFusContext, newPageContext, RequestMonitorData.getCurrent());
            completionService.submit(method);
        }
        originalFusContext.setParallelCall(false);
    }

    public static void submitCallablesForStruct(Map s, UDFMethod udfMethod, CompletionService completionService) throws CloneNotSupportedException {
        Iterator i = s.entrySet().iterator();
        FusionContext originalFusContext = FusionContext.getCurrent();
        originalFusContext.setParallelCall(true);
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            String keyname = (String)key;
            Object value = e.getValue();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableMethod method = new CallableMethod(udfMethod, null, new Object[]{keyname, value, s}, newFusContext, newPageContext, RequestMonitorData.getCurrent(), key, value);
            completionService.submit(method);
        }
        originalFusContext.setParallelCall(false);
    }

    public static void submitCallablesForQuery(Object queryObj, UDFMethod udfMethod, CompletionService completionService) throws CloneNotSupportedException {
        FusionContext originalFusContext = FusionContext.getCurrent();
        originalFusContext.setParallelCall(true);
        Table query = (Table)queryObj;
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableMethod method = new CallableMethod(udfMethod, null, new Object[]{rowData, i, query}, newFusContext, newPageContext, RequestMonitorData.getCurrent());
            completionService.submit(method);
        }
        originalFusContext.setParallelCall(false);
    }

    public static java.util.concurrent.Future submitMetricCalculatorTask(Callable callable, ExecutorService executor) {
        return executor.submit(callable);
    }

    public static void printOutput(Object printMe) throws IOException {
        if (printMe == null) {
            return;
        }
        JspWriter outWriter = FusionContext.getCurrent().pageContext.getOut();
        if (outWriter instanceof CFOutput) {
            ((CFOutput)outWriter).cfoutput(true);
        }
        outWriter.print(printMe);
        if (outWriter instanceof CFOutput) {
            ((CFOutput)outWriter).cfoutput(false);
        }
    }

    public static ExecutorService createThreadPool(int maxThreadCount) throws IOException {
        if (maxThreadCount < 1 || maxThreadCount > 50) {
            throw new RuntimeException("The value of maxThreadCount must be between 1-50.");
        }
        return Executors.newFixedThreadPool(maxThreadCount);
    }
}

