/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.protobuf;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.protobuf.CFProtocolBuffer;
import coldfusion.runtime.protobuf.PlatformDetector;
import coldfusion.runtime.protobuf.ProtocolBufferUtils;
import coldfusion.runtime.util.SerializationUtil;
import coldfusion.server.ServiceFactory;
import coldfusion.util.LruCache;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import com.google.protobuf.Descriptors;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;

public class CFProtoBufCore {
    private static final String directory = ServiceFactory.getRuntimeService().getRootDir();
    private static String TMP_CACHE = "tmpCache";
    private static String tmpdir = System.getProperty("coldfusion.temp.dir", directory + File.separatorChar + TMP_CACHE);
    private static String CF_PROTO_TEMP_FOLDER = "cf_proto_temp";
    private static final boolean serializerTrustedCache = Boolean.parseBoolean(System.getProperty("coldfusion.serializer.trustedCache.enable", "false"));
    private static final int trustedCacheSize = Integer.parseInt(System.getProperty("coldfusion.serializer.trustedCache.size", "100"));
    private static final LruCache cache = new LruCache(trustedCacheSize){

        @Override
        protected Object fetch(Object key) {
            File protoFile = null;
            File descriptorFile = null;
            boolean fileExist = true;
            try {
                String protoPath;
                CFProtoSchema schema = (CFProtoSchema)key;
                String filePathOrSchema = schema.schemaOrPath;
                boolean isVirtualFile = VFSFileFactory.checkIfVFile(filePathOrSchema);
                if (isVirtualFile) {
                    throw new ProtocolBufferUtils.ProtocolBufferSerializationException(RB.getString(this, "PROTOBUF.UNSUPPORTED_VFS"));
                }
                protoFile = schema.getFile();
                if (!protoFile.exists()) {
                    fileExist = false;
                    protoFile = CFProtoBufCore.generateFileFromContent(filePathOrSchema);
                    protoPath = protoFile.getParentFile().getCanonicalPath();
                } else {
                    protoPath = schema.getProtoPathFile().getCanonicalPath();
                }
                CFProtocolBuffer cFProtocolBuffer = CFProtoBufCore.getCfProtocolBuffer(protoFile, false, protoPath);
                return cFProtocolBuffer;
            }
            catch (ProtocolBufferUtils.ProtocolBufferSerializationException ex) {
                if (!fileExist) {
                    throw new ProtocolBufferUtils.ProtocolBufferSerializationException(RB.getString(this, "PROTOBUF.INVALID_SCHEMA"));
                }
                throw ex;
            }
            catch (Exception e) {
                if (!fileExist) {
                    throw new ProtocolBufferUtils.ProtocolBufferSerializationException(RB.getString(this, "PROTOBUF.INVALID_SCHEMA"));
                }
                throw new ProtocolBufferUtils.ProtocolBufferSerializationException(e.getMessage());
            }
            finally {
                if (!fileExist) {
                    if (protoFile != null) {
                        protoFile.delete();
                    }
                    if (descriptorFile != null) {
                        descriptorFile.delete();
                    }
                }
            }
        }

        @Override
        public Object get(Object key) {
            CFProtocolBuffer protocolBuffer = (CFProtocolBuffer)super.get(key);
            if (serializerTrustedCache) {
                return protocolBuffer;
            }
            CFProtoSchema schema = (CFProtoSchema)key;
            File keyFile = schema.getFile();
            File parentFile = schema.getProtoPathFile();
            boolean modified = false;
            if (keyFile.exists() && parentFile.exists()) {
                for (String name : protocolBuffer.getProtoNames()) {
                    File protoFile = new File(parentFile.getAbsolutePath(), name);
                    if (!protoFile.exists() || protoFile.lastModified() <= protocolBuffer.generatedTime) continue;
                    modified = true;
                    break;
                }
            }
            if (modified) {
                super.remove(key);
                try {
                    File oldDescriptorFile = CFProtoBufCore.setupPath(keyFile);
                    if (oldDescriptorFile.exists()) {
                        oldDescriptorFile.delete();
                    }
                }
                catch (IOException e) {
                    try {
                        return CFProtoBufCore.getCfProtocolBuffer(keyFile, true, parentFile.getCanonicalPath());
                    }
                    catch (Exception ex) {
                        throw new ProtocolBufferUtils.ProtocolBufferSerializationException(ex, "");
                    }
                }
                return super.get(key);
            }
            return protocolBuffer;
        }
    };

    private static CFProtocolBuffer getCfProtocolBuffer(File keyFile, boolean force, String protoPath) throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        File oldDescriptorFile = CFProtoBufCore.setupPath(keyFile);
        CFProtoBufCore.generateDescriptor(keyFile, oldDescriptorFile.getCanonicalPath(), force, protoPath);
        return new CFProtocolBuffer(oldDescriptorFile.getCanonicalPath(), Paths.get(protoPath, new String[0]).relativize(keyFile.toPath()).toString());
    }

    public static CFProtocolBuffer getCfProtocolBuffer(CFProtoSchema schema) throws IOException {
        CFProtocolBuffer cfProtocolBuffer = (CFProtocolBuffer)cache.get(schema);
        return cfProtocolBuffer;
    }

    private static File generateFileFromContent(String content) {
        String outPath;
        File temp;
        int hc = content.hashCode();
        if (hc < 0) {
            hc ^= 0xFFFFFFFF;
        }
        if (!(temp = new File(outPath = tmpdir + File.separator + CF_PROTO_TEMP_FOLDER + File.separator + hc + content.length() + System.currentTimeMillis() + ".proto")).getParentFile().exists()) {
            temp.getParentFile().mkdir();
        }
        try {
            Files.write(temp.toPath(), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(RB.getString(CFProtoBufCore.class, "PROTOBUF.WRITE_ERROR"), e);
            throw new ProtocolBufferUtils.ProtocolBufferSerializationException(RB.getString(CFProtoBufCore.class, "PROTOBUF.IO_MESSAGE"));
        }
        return temp;
    }

    private static void generateDescriptor(File f, String outPath, boolean force, String protoPath) throws IOException, InterruptedException {
        File outFile = new File(outPath);
        if (!force && outFile.exists() && f.lastModified() < outFile.lastModified()) {
            return;
        }
        Process protoc = null;
        ArrayList<String> args = new ArrayList<String>();
        args.add(CFProtoBufCore.getProtoCompiler());
        args.add("--descriptor_set_out=" + outPath);
        args.add("--include_imports");
        args.add("--proto_path=" + protoPath);
        args.add(Paths.get(protoPath, new String[0]).relativize(f.toPath()).toString());
        int retryCount = 1;
        while (protoc == null) {
            ProcessBuilder pb = new ProcessBuilder(args);
            try {
                protoc = AccessController.doPrivileged(() -> {
                    try {
                        return pb.start();
                    }
                    catch (IOException e) {
                        throw new ProtocolBufferUtils.ProtocolBufferSerializationException(e, e.getMessage());
                    }
                });
            }
            catch (ProtocolBufferUtils.ProtocolBufferSerializationException e) {
                if (retryCount++ > 3) {
                    throw e;
                }
                Thread.sleep(500L);
            }
        }
        protoc.waitFor();
        if (protoc.exitValue() != 0) {
            String error = new BufferedReader(new InputStreamReader(protoc.getErrorStream())).lines().collect(Collectors.joining("\n"));
            throw new ProtocolBufferUtils.ProtocolBufferSerializationException(error);
        }
    }

    private static String getProtoCompiler() {
        String executablePath = directory + File.separator + "bin" + File.separator + "protoc";
        Path path = Paths.get(executablePath, PlatformDetector.getOS().getValue());
        if (!path.toFile().exists()) {
            throw new ProtocolBufferCompilerNotFound("");
        }
        if (!(path = Paths.get(path.toString(), PlatformDetector.getOsArchitecture().getValue())).toFile().exists()) {
            if (PlatformDetector.getOS().equals((Object)PlatformDetector.OS.MAC)) {
                path = Paths.get(path.getParent().toString(), "universal_binary");
            } else {
                throw new ProtocolBufferCompilerNotFound("");
            }
        }
        try {
            return Paths.get(path.toString(), "bin", "protoc").toFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new ProtocolBufferCompilerNotFound(e, e.getMessage());
        }
    }

    private static File setupPath(File protoFile) throws IOException {
        String outPath = tmpdir + File.separator + CF_PROTO_TEMP_FOLDER + File.separator + CFProtoBufCore.generateUniqueFileName(protoFile) + ".pb";
        File temp = new File(outPath);
        if (!temp.getParentFile().exists()) {
            temp.getParentFile().mkdir();
        }
        return temp;
    }

    private static String generateUniqueFileName(File protoFile) throws IOException {
        String fileName = protoFile.getName();
        StringBuffer buf = new StringBuffer(fileName.length() + 20);
        char[] rep = new char[4];
        buf.append("cf");
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                if (c == '/') {
                    buf.append('_');
                    buf.append('_');
                    continue;
                }
                String hex = String.format("%04x", c);
                int len = hex.length();
                buf.append(hex, 0, len);
                continue;
            }
            buf.append(c);
        }
        int hc = protoFile.hashCode();
        if (hc < 0) {
            hc ^= 0xFFFFFFFF;
        }
        buf.append(hc);
        return buf.toString();
    }

    public static class ProtocolBufferCompilerNotFound
    extends ApplicationException {
        public final String message;

        public ProtocolBufferCompilerNotFound(String message) {
            this.message = message;
        }

        public ProtocolBufferCompilerNotFound(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }

    static class CFProtoSchema {
        String schemaOrPath;
        String protoPath;

        public CFProtoSchema(String schema, String protoPath) {
            this.schemaOrPath = schema;
            this.protoPath = protoPath;
        }

        public CFProtoSchema(String schema) {
            this.schemaOrPath = schema;
        }

        public File getFile() {
            return this.protoPath == null || this.protoPath.isEmpty() ? SerializationUtil.getFile(this.schemaOrPath) : new File(this.protoPath, this.schemaOrPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CFProtoSchema that = (CFProtoSchema)o;
            return Objects.equals(this.schemaOrPath, that.schemaOrPath) && Objects.equals(this.protoPath, that.protoPath);
        }

        public int hashCode() {
            return Objects.hash(this.schemaOrPath, this.protoPath);
        }

        public File getProtoPathFile() {
            return this.protoPath == null || this.protoPath.isEmpty() ? SerializationUtil.getFile(this.schemaOrPath).getParentFile() : new File(this.protoPath);
        }
    }
}

