/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.provider;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Cast;
import coldfusion.runtime.TemplateProxy;
import jakarta.servlet.jsp.PageContext;
import java.util.Map;
import java.util.regex.Pattern;

public class SerializerProxyWrapper {
    private static final String JSON = "JSON";
    private static final String XML = "XML";
    private static final String AVRO = "AVRO";
    private static final String PROTOBUF = "PROTOBUF";
    private static final String CAN_SERIALIZE = "canSerialize";
    private static final String SERIALIZE_DATA = "serialize";
    private static final String CAN_DESERIALIZE = "canDeserialize";
    private static final String DESERIALIZE_DATA = "deserialize";
    private final TemplateProxy proxy;
    private static final Pattern XMLRegex = Pattern.compile("(.)*[Xx][Mm][Ll](.)*");
    private static final Pattern JSONRegex = Pattern.compile("(.)*[Jj][Ss][Oo][Nn](.)*");
    private static final Pattern AVRO_REGEX = Pattern.compile("(.)*[Aa][Vv][Rr][Oo](.)*");
    private static final Pattern PROTOBUF_REGEX = Pattern.compile("(.)*[Pp][Rr][Oo][Tt][Oo][Bb][Uu][Ff](.)*");

    public SerializerProxyWrapper(TemplateProxy proxy) throws Throwable {
        this.proxy = proxy;
    }

    public Object serialize(Object obj, String acceptType, Map additionalArgs) throws Throwable {
        acceptType = SerializerProxyWrapper.getType(acceptType);
        Object[] args = additionalArgs == null ? new Object[]{obj, acceptType} : new Object[]{obj, acceptType, additionalArgs};
        Object invoke = this.proxy.invoke(SERIALIZE_DATA, args, (PageContext)FusionContext.getCurrent().pageContext);
        return invoke;
    }

    public String serialize(Object obj, String acceptType) throws Throwable {
        return (String)this.serialize(obj, acceptType, null);
    }

    public Object deserialize(Object dataToBeDeserialized, String mimeType, String returnType, Map additionalArgs) throws Throwable {
        Object[] args;
        mimeType = SerializerProxyWrapper.getType(mimeType);
        if (additionalArgs != null) {
            args = new Object[]{dataToBeDeserialized, mimeType, returnType, additionalArgs};
        } else {
            Object[] objectArray;
            if (returnType == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = dataToBeDeserialized;
                objectArray = objectArray2;
                objectArray2[1] = mimeType;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = dataToBeDeserialized;
                objectArray3[1] = mimeType;
                objectArray = objectArray3;
                objectArray3[2] = returnType;
            }
            args = objectArray;
        }
        return this.proxy.invoke(DESERIALIZE_DATA, args, (PageContext)FusionContext.getCurrent().pageContext);
    }

    public Object deserialize(String strToBeDeserialized, String mimeType, String returnType) throws Throwable {
        return this.deserialize(strToBeDeserialized, mimeType, returnType, null);
    }

    public boolean canSerialize(String mediaType) throws Throwable {
        Object[] args = SerializerProxyWrapper.getArgs(mediaType);
        return Cast._boolean(this.proxy.invoke(CAN_SERIALIZE, args, (PageContext)FusionContext.getCurrent().pageContext));
    }

    public boolean canDeSerialize(String mediaType) throws Throwable {
        Object[] args = SerializerProxyWrapper.getArgs(mediaType);
        return Cast._boolean(this.proxy.invoke(CAN_DESERIALIZE, args, (PageContext)FusionContext.getCurrent().pageContext));
    }

    private static Object[] getArgs(String mediaType) {
        Object[] args = new Object[]{SerializerProxyWrapper.getType(mediaType)};
        return args;
    }

    private static String getType(String acceptType) {
        if (XMLRegex.matcher(acceptType).matches()) {
            acceptType = XML;
        } else if (JSONRegex.matcher(acceptType).matches()) {
            acceptType = JSON;
        } else if (AVRO_REGEX.matcher(acceptType).matches()) {
            acceptType = AVRO;
        } else if (PROTOBUF_REGEX.matcher(acceptType).matches()) {
            acceptType = PROTOBUF;
        }
        return acceptType;
    }
}

