/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.wddx.Base64Encoder;
import javax.xml.stream.XMLStreamException;

public class BinaryHandler
extends AbstractHandler {
    public BinaryHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return obj instanceof byte[];
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        generator.addText(Base64Encoder.encode((byte[])obj));
    }

    @Override
    public String getType(Object obj) {
        return "BINARY";
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "BINARY".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class type, boolean useCustomeSerializer) throws Handler.XMLParseException {
        int eventType = reader.getEventType();
        if (eventType != 4) {
            throw new Handler.XMLParseException("Invalid xml content for parsing Binary. Expected a simple Base64 encoded value.");
        }
        String text = reader.getText();
        byte[] result = Base64Encoder.decode(text);
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(e);
        }
        return result;
    }
}

