/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.Cast;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import javax.xml.stream.XMLStreamException;

public class BooleanHandler
extends AbstractHandler {
    public BooleanHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return obj instanceof Boolean;
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        generator.addText(String.valueOf(obj).trim());
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "BOOLEAN".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class type, boolean useCustomeSerializer) throws Handler.XMLParseException {
        boolean returnValue;
        int eventType = reader.getEventType();
        if (eventType != 4) {
            throw new Handler.XMLParseException(RB.getString(this, "BooleanHandler.InvalidValue"));
        }
        String text = reader.getText();
        if (null == text || text.trim().length() == 0) {
            throw new Handler.XMLParseException(RB.getString(this, "BooleanHandler.InvalidValue"));
        }
        try {
            returnValue = Cast._boolean(text.trim());
        }
        catch (Cast.NumberConversionException e) {
            throw new Handler.XMLParseException(RB.getString(this, "BooleanHandler.InvalidValue"));
        }
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(e);
        }
        return returnValue;
    }

    @Override
    public String getType(Object obj) {
        return "BOOLEAN";
    }
}

