/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import coldfusion.xml.rpc.CFComponentSkeleton;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class CFComponentHandler
extends AbstractHandler {
    public CFComponentHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return CFComponentSkeleton.class.isAssignableFrom(obj.getClass()) || obj instanceof TemplateProxy;
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        generator.addStartElement("COMPONENT");
        Integer idRef = generator.getIDRef(obj);
        if (null == idRef) {
            int generatedId = generator.addSerializedObject(obj);
            generator.addAttribute("ID", String.valueOf(generatedId));
            TemplateProxy cfc = null;
            cfc = obj instanceof TemplateProxy ? (TemplateProxy)obj : ((CFComponentSkeleton)obj).__getTemplateProxy();
            generator.addAttribute("NAME", cfc.getCfcFullyQualifiedName());
            Map<String, Object> map = null;
            map = obj instanceof TemplateProxy ? this.getCFCData((TemplateProxy)obj) : this.getCFCData((CFComponentSkeleton)obj);
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value instanceof UDFMethod) continue;
                generator.addStartElement("PROPERTY");
                generator.addAttribute("NAME", key);
                Handler serializer = this.registry.getSerializer(value);
                generator.addAttribute("TYPE", serializer.getType(value));
                serializer.serialize(generator, value, useCustomSerializer);
                generator.addEndElement();
            }
        } else {
            generator.addAttribute("IDREF", String.valueOf(idRef));
        }
        generator.addEndElement();
    }

    private Map<String, Object> getCFCData(TemplateProxy obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : obj.keySet()) {
            Object val = obj.get(key);
            map.put(key, val);
        }
        return map;
    }

    private Map<String, Object> getCFCData(CFComponentSkeleton obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FastHashtable __getProps = obj.__getProps();
        for (Object keyObj : __getProps.keySet()) {
            Object value = __getProps.get(keyObj);
            if (value instanceof UDFMethod) continue;
            map.put(Cast._String(keyObj), value);
        }
        return map;
    }

    @Override
    public String getType(Object obj) {
        return "COMPONENT";
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "COMPONENT".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class datatype, boolean useCustomeSerializer) throws Handler.XMLParseException {
        TemplateProxy returnObj = null;
        try {
            int eventType = reader.getEventType();
            if (1 != eventType || !reader.getLocalName().equalsIgnoreCase("COMPONENT")) {
                throw new Handler.XMLParseException(RB.getString((Object)this, "CFComponentHandler.InvalidStartElement", new Object[]{reader.getLocalName()}));
            }
            String componentName = null;
            String idRef = null;
            String id = null;
            int attributeCount = reader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String attributeLocalName = reader.getAttributeLocalName(i);
                if ("NAME".equalsIgnoreCase(attributeLocalName)) {
                    componentName = reader.getAttributeValue(i);
                    continue;
                }
                if ("IDREF".equalsIgnoreCase(attributeLocalName)) {
                    idRef = reader.getAttributeValue(i).trim();
                    continue;
                }
                if ("ID".equalsIgnoreCase(attributeLocalName)) {
                    id = reader.getAttributeValue(i).trim();
                    continue;
                }
                CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
            }
            if (null == idRef) {
                if (null == componentName) {
                    throw new Handler.XMLParseException(RB.getString(this, "CFComponentHandler.NameIsMandatory"));
                }
                String path = "/" + componentName.replace('.', '/') + ".cfc";
                NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
                String outputdir = (String)pageContext.getServletContext().getAttribute("coldfusion.rest.servlet.CFRestServlet.outputdir");
                try {
                    FusionContext.getCurrent().pageContext.getServletContext().setAttribute("coldfusion.rest.servlet.CFRestServlet.outputdir", (Object)outputdir);
                    returnObj = TemplateProxyFactory.resolvePath(path, pageContext);
                }
                catch (Throwable e) {
                    throw new Handler.XMLParseException(RB.getString((Object)this, "CFComponentHandler.CouldNotFindComponent", new Object[]{reader.getLocalName()}), e);
                }
                reader.addDeSerializedObject(id, returnObj);
                int next = reader.next();
                while (!(next == 2 && "COMPONENT".equalsIgnoreCase(reader.getLocalName()))) {
                    String localName = reader.getLocalName();
                    if (!"PROPERTY".equalsIgnoreCase(localName)) {
                        throw new Handler.XMLParseException(RB.getString((Object)this, "CFComponentHandler.ExpectedProperty", new Object[]{localName}));
                    }
                    String propertyName = null;
                    String type = null;
                    attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        String attributeLocalName = reader.getAttributeLocalName(i);
                        if ("NAME".equalsIgnoreCase(attributeLocalName)) {
                            propertyName = reader.getAttributeValue(i);
                            continue;
                        }
                        if ("TYPE".equalsIgnoreCase(attributeLocalName)) {
                            type = reader.getAttributeValue(i);
                            continue;
                        }
                        CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
                    }
                    if (null == propertyName || propertyName.trim().length() == 0) {
                        throw new Handler.XMLParseException(RB.getString(this, "CFComponentHandler.NameIsMandatoryForProperty"));
                    }
                    if (null == type || type.trim().length() == 0) {
                        throw new Handler.XMLParseException(RB.getString(this, "CFComponentHandler.TypeIsMandatoryForProperty"));
                    }
                    Handler handler = this.registry.getDeserializer(type);
                    reader.next();
                    Object value = handler.deserialize(reader, Object.class, useCustomeSerializer);
                    returnObj.put(propertyName, value);
                    next = reader.next();
                }
            } else {
                Object referencedObject = reader.getReferencedObject(idRef);
                if (!(referencedObject instanceof TemplateProxy)) {
                    throw new Handler.XMLParseException(RB.getString((Object)this, "CFComponentHandler.InvalidReferencedObject", new Object[]{this.registry.getSerializer(referencedObject).getType(referencedObject)}));
                }
                returnObj = (TemplateProxy)referencedObject;
                reader.next();
            }
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(RB.getString(this, "Handler.GeneralMessage"), e);
        }
        return returnObj;
    }
}

