/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Cast;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.provider.SerializerProxyWrapper;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import coldfusion.xml.rpc.CFComponentSkeleton;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.QueryBean;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CustomHandler
extends AbstractHandler {
    public static final String XML = "XML";

    public CustomHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        return null != serializerProxy && this.isDifferentObjectToBeSerialized(obj);
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        if (useCustomSerializer) {
            SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
            FusionContext context = FusionContext.getCurrent();
            Object oldData = context.getCurrentSerializedData();
            String result = null;
            try {
                if (serializerProxy.canSerialize(XML)) {
                    context.setCurrentSerializedData(obj);
                    result = serializerProxy.serialize(obj, XML);
                }
            }
            catch (Throwable e) {
                throw new SerializationException(e.getMessage());
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
            generator.addText(result);
        } else {
            Handler defaultSerializer = this.registry.getDefaultSerializer(obj);
            defaultSerializer.serialize(generator, obj, useCustomSerializer);
        }
    }

    @Override
    public String getType(Object obj) {
        return this.registry.getDefaultSerializer(obj).getType(obj);
    }

    @Override
    public boolean canDeSerialize(String type) {
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        return null != serializerProxy;
    }

    @Override
    public Object deserialize(XMLReader reader, Class datatype, boolean useCustomSerializer) throws Handler.XMLParseException {
        String xmlStr = reader.getCurrentNodeStr();
        if (useCustomSerializer && this.isDifferentObjectToBeSerialized(xmlStr)) {
            SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
            FusionContext context = FusionContext.getCurrent();
            Object oldData = context.getCurrentSerializedData();
            String typeName = datatype != null ? datatype.getName() : "";
            Object deserializedResult = null;
            try {
                if (serializerProxy.canDeSerialize(XML)) {
                    context.setCurrentSerializedData(xmlStr);
                    deserializedResult = serializerProxy.deserialize(xmlStr, XML, typeName);
                }
            }
            catch (Throwable e) {
                throw new Handler.XMLParseException(RB.getString(this, "Handler.GeneralMessage"), e);
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
            this.updateReaderPos(reader, xmlStr);
            return deserializedResult;
        }
        String type = CustomHandler.getType(datatype, xmlStr);
        Handler deserializer = this.registry.getDefaultDeserializer(type);
        return deserializer.deserialize(reader, datatype, useCustomSerializer);
    }

    private static String getType(Class type, String xml) {
        if (null == type || Object.class.equals((Object)type)) {
            return CustomHandler.getTypeFromXML(xml);
        }
        if (Map.class.isAssignableFrom(type)) {
            return "STRUCT";
        }
        if (QueryBean.class.isAssignableFrom(type) || DocumentQueryBean.class.isAssignableFrom(type)) {
            return "QUERY";
        }
        if (CFComponentSkeleton.class.isAssignableFrom(type)) {
            return "COMPONENT";
        }
        if (Number.class.isAssignableFrom(type)) {
            return "NUMBER";
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return "BOOLEAN";
        }
        if (Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type)) {
            return "DATE";
        }
        if (type == byte[].class) {
            return "BINARY";
        }
        if (type.isArray()) {
            return "ARRAY";
        }
        if (Document.class.equals((Object)type)) {
            return "DOCUMENT";
        }
        return null;
    }

    private static String getTypeFromXML(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            InputSource is = new InputSource(new StringReader(xml));
            Document doc = builder.parse(is);
            String localName = doc.getFirstChild().getNodeName();
            if (localName != null) {
                if ("STRUCT".equals(localName = localName.toUpperCase())) {
                    return "STRUCT";
                }
                if ("QUERY".equals(localName)) {
                    return "QUERY";
                }
                if ("COMPONENT".equals(localName)) {
                    return "COMPONENT";
                }
                if ("ARRAY".equals(localName)) {
                    return "ARRAY";
                }
            }
            return "DOCUMENT";
        }
        catch (Exception e) {
            Object localName = null;
            try {
                Cast._double(xml, false, false);
                return "NUMBER";
            }
            catch (Exception exception) {
                try {
                    Cast._boolean(xml);
                    return "BOOLEAN";
                }
                catch (Exception exception2) {
                    try {
                        Cast._Date(xml);
                        return "DATE";
                    }
                    catch (Exception exception3) {
                        return "STRING";
                    }
                }
            }
        }
    }

    public SerializerProxyWrapper getSerializerProxy() {
        Map appSettings;
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            SerializerProxyWrapper serializerProxyWrapper = (SerializerProxyWrapper)appSettings.get("CustomSerializerInstance");
            if (null != serializerProxyWrapper) {
                return serializerProxyWrapper;
            }
            String serializer = (String)appSettings.get("CustomSerializer");
            if (null != serializer) {
                try {
                    SerializerProxyWrapper serializerProxy = new SerializerProxyWrapper(TemplateProxyFactory.resolveName(serializer, FusionContext.getCurrent().pageContext));
                    appSettings.put("CustomSerializerInstance", serializerProxy);
                    return serializerProxy;
                }
                catch (Throwable e) {
                    logger.error(e);
                }
            }
        }
        return null;
    }

    public boolean isDifferentObjectToBeSerialized(Object obj) {
        Object currentSerializedData = FusionContext.getCurrent().getCurrentSerializedData();
        return null == currentSerializedData || null != currentSerializedData && false == currentSerializedData.equals(obj);
    }

    public boolean canDeserializeUsingCustomSerializer(XMLReader reader, boolean useCustomSerializer) {
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        return useCustomSerializer && null != serializerProxy && this.isDifferentObjectToBeSerialized(reader.getXML());
    }
}

