/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.stream.XMLStreamException;

public class DateHandler
extends AbstractHandler {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM, dd yyyy HH:mm:ss");

    public DateHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return obj instanceof Calendar || obj instanceof Date;
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        String dt = "";
        if (obj instanceof Calendar) {
            dt = this.dateFormat.format(((Calendar)obj).getTime());
        } else if (obj instanceof Date) {
            dt = this.dateFormat.format((Date)obj);
        }
        generator.addText(dt);
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "DATE".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class type, boolean useCustomeSerializer) throws Handler.XMLParseException {
        Date instance = null;
        int eventType = reader.getEventType();
        if (eventType != 4) {
            throw new Handler.XMLParseException(RB.getString(this, "DateHandler.InvalidValue"));
        }
        String text = reader.getText();
        if (null == text || text.trim().length() == 0) {
            throw new Handler.XMLParseException(RB.getString(this, "DateHandler.InvalidValue"));
        }
        try {
            instance = this.dateFormat.parse(text.trim());
        }
        catch (ParseException e1) {
            try {
                instance = Cast._Date(text.trim());
            }
            catch (Cast.DateStringConversionException e) {
                throw new Handler.XMLParseException(RB.getString(this, "DateHandler.InvalidValue"));
            }
        }
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(e);
        }
        return new OleDateTime(instance);
    }

    @Override
    public String getType(Object obj) {
        return "DATE";
    }
}

