/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.Cast;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import coldfusion.xml.XmlNodeList;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentHandler
extends AbstractHandler {
    private static final String XML_PROLOGUE_START = "<?xml";
    private static final TransformerFactory TARNSFORMER_FACTORY = TransformerFactory.newInstance();

    public DocumentHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return Document.class.isAssignableFrom(obj.getClass()) || obj instanceof XmlNodeList;
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        Node node = null;
        node = obj instanceof Node ? (Node)obj : ((XmlNodeList)obj).getFirstNode();
        try {
            Transformer trans = TARNSFORMER_FACTORY.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            trans.transform(source, result);
            String xmlString = sw.toString();
            boolean isStartingWithPrologue = xmlString.startsWith(XML_PROLOGUE_START);
            if (isStartingWithPrologue) {
                int prologueEndIndex = xmlString.indexOf("?>");
                xmlString = xmlString.substring(prologueEndIndex + 2);
            }
            generator.addChildElement(xmlString);
        }
        catch (Exception e) {
            throw new SerializationException(RB.getString(this, "DocumentHandler.InvalidValue"), e);
        }
    }

    @Override
    public String getType(Object obj) {
        return "DOCUMENT";
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "DOCUMENT".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class type, boolean useCustomeSerializer) throws Handler.XMLParseException {
        String xml = reader.getCurrentNodeStr();
        this.updateReaderPos(reader, xml);
        Document returnObject = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            returnObject = builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException e) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "DocumentHandler.ExceptionParsingXML", new Object[]{xml}), e);
        }
        catch (SAXException e) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "DocumentHandler.ExceptionParsingXML", new Object[]{xml}), e);
        }
        catch (IOException e) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "DocumentHandler.ExceptionParsingXML", new Object[]{xml}), e);
        }
        return Cast._Xml(returnObject);
    }
}

