/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.Cast;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import javax.xml.stream.XMLStreamException;

public class NumericHandler
extends AbstractHandler {
    public NumericHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return obj instanceof Number;
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        generator.addText(String.valueOf(obj).trim());
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "NUMBER".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class type, boolean useCustomeSerializer) throws Handler.XMLParseException {
        double returnValue = -1.0;
        int eventType = reader.getEventType();
        if (eventType != 4) {
            throw new Handler.XMLParseException(RB.getString(this, "NumericHandler.InvalidValue"));
        }
        String text = reader.getText();
        if (null == text || text.trim().length() == 0) {
            throw new Handler.XMLParseException(RB.getString(this, "NumericHandler.InvalidValue"));
        }
        try {
            returnValue = Cast._double(text.trim());
        }
        catch (Cast.NumberConversionException e) {
            throw new Handler.XMLParseException(RB.getString(this, "NumericHandler.InvalidValue"));
        }
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(e);
        }
        return returnValue;
    }

    @Override
    public String getType(Object obj) {
        return "NUMBER";
    }
}

