/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.InvalidSerializerException;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.xml.ArrayHandler;
import coldfusion.runtime.xml.BinaryHandler;
import coldfusion.runtime.xml.BooleanHandler;
import coldfusion.runtime.xml.CFBooleanHandler;
import coldfusion.runtime.xml.CFComponentHandler;
import coldfusion.runtime.xml.CustomHandler;
import coldfusion.runtime.xml.DateHandler;
import coldfusion.runtime.xml.DocumentHandler;
import coldfusion.runtime.xml.DummyHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.NullHandler;
import coldfusion.runtime.xml.NumericHandler;
import coldfusion.runtime.xml.QueryHandler;
import coldfusion.runtime.xml.StringHandler;
import coldfusion.runtime.xml.StructHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Registry {
    private static final Map<String, Registry> registries = new HashMap<String, Registry>();
    private final List<Handler> registeredHandlers = new LinkedList<Handler>();
    private final List<Handler> defaultHandlers = new LinkedList<Handler>();

    private Registry() {
        this.defaultHandlers.add(new NullHandler(this));
        this.defaultHandlers.add(new CFComponentHandler(this));
        this.defaultHandlers.add(new StructHandler(this));
        this.defaultHandlers.add(new BinaryHandler(this));
        this.defaultHandlers.add(new StringHandler(this));
        this.defaultHandlers.add(new NumericHandler(this));
        this.defaultHandlers.add(new CFBooleanHandler(this));
        this.defaultHandlers.add(new BooleanHandler(this));
        this.defaultHandlers.add(new DateHandler(this));
        this.defaultHandlers.add(new ArrayHandler(this));
        this.defaultHandlers.add(new DocumentHandler(this));
        this.defaultHandlers.add(new QueryHandler(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Registry getRegistry(String appName) {
        String serializer;
        Registry registry = registries.get(appName);
        if (null == registry) {
            Class<Registry> clazz = Registry.class;
            // MONITORENTER : coldfusion.runtime.xml.Registry.class
            registry = registries.get(appName);
            if (null == registry) {
                Registry newRegistry = new Registry();
                registries.put(appName, newRegistry);
                registry = registries.get(appName);
            }
            // MONITOREXIT : clazz
        }
        if (null != (serializer = Registry.getSerializer())) {
            Registry.validateSerializer(serializer);
            registry.clearRegisterHandlers();
            registry.registerHandler(new CustomHandler(registry));
            return registry;
        }
        registry.clearRegisterHandlers();
        return registry;
    }

    private static void validateSerializer(String serializer) {
        try {
            TemplateProxyFactory.resolveName(serializer, FusionContext.getCurrent().pageContext);
        }
        catch (Throwable e) {
            throw new InvalidSerializerException(serializer, e);
        }
    }

    private static String getSerializer() {
        Map appSettings;
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        String serializer = null;
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            serializer = (String)appSettings.get("CustomSerializer");
        }
        return serializer;
    }

    public void registerHandler(Handler handler) {
        this.registeredHandlers.add(handler);
    }

    public void clearRegisterHandlers() {
        this.registeredHandlers.clear();
    }

    public Handler getSerializer(Object obj) {
        Handler handler = this.findSerializer(obj);
        if (null == handler) {
            return new DummyHandler();
        }
        return handler;
    }

    private Handler findSerializer(Object obj) {
        for (Handler handler : this.registeredHandlers) {
            if (!handler.canSerialize(obj)) continue;
            return handler;
        }
        for (Handler handler : this.defaultHandlers) {
            if (!handler.canSerialize(obj)) continue;
            return handler;
        }
        return null;
    }

    public Handler getDeserializer(String type) {
        Handler handler = this.findDeserializer(type);
        if (null == handler) {
            return new DummyHandler();
        }
        return handler;
    }

    private Handler findDeserializer(String type) {
        for (Handler handler : this.registeredHandlers) {
            if (!handler.canDeSerialize(type)) continue;
            return handler;
        }
        for (Handler handler : this.defaultHandlers) {
            if (!handler.canDeSerialize(type)) continue;
            return handler;
        }
        return null;
    }

    public Handler getDefaultSerializer(Object obj) {
        for (Handler handler : this.defaultHandlers) {
            if (!handler.canSerialize(obj)) continue;
            return handler;
        }
        return new DummyHandler();
    }

    public Handler getDefaultDeserializer(String type) {
        for (Handler handler : this.defaultHandlers) {
            if (!handler.canDeSerialize(type)) continue;
            return handler;
        }
        return new DummyHandler();
    }
}

