/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.Cast;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.runtime.xml.XPathExprGenerator;
import coldfusion.util.RB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.SAXException;

public class StAXXMLReader
implements XMLReader {
    private final XMLStreamReader reader;
    private final Map<Integer, Object> deserializedObjects = new HashMap<Integer, Object>();
    private final String xml;
    private final XPathExprGenerator generator;

    public StAXXMLReader(String xml) throws XMLStreamException, FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        this.xml = xml;
        this.generator = new XPathExprGenerator(this.xml);
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.reader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.reader.getAttributeValue(index);
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public int next() throws XMLStreamException {
        int next = this.reader.next();
        int eventType = this.reader.getEventType();
        switch (eventType) {
            case 1: {
                this.generator.addStartElement(this.reader.getLocalName());
                break;
            }
            case 2: {
                this.generator.addEndElement(this.reader.getLocalName());
                break;
            }
            case 4: {
                String text = this.reader.getText();
                if (0 == text.trim().length()) {
                    next = this.next();
                    break;
                }
                this.generator.setText();
                break;
            }
        }
        return next;
    }

    @Override
    public Object getReferencedObject(String idRef) throws Handler.XMLParseException {
        Integer idRefVal;
        try {
            idRefVal = Cast._int(idRef.trim());
        }
        catch (Cast.NumberConversionException e) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "StAXXMLReader.InvalidIDRef", new Object[]{idRef}));
        }
        Object referencedObject = this.deserializedObjects.get(idRefVal);
        if (null == referencedObject) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "StAXXMLReader.InvalidIDRefReference", new Object[]{idRef}));
        }
        return referencedObject;
    }

    @Override
    public void addDeSerializedObject(String id, Object object) throws Handler.XMLParseException {
        Integer integer;
        try {
            integer = Cast._int(id.trim());
        }
        catch (Cast.NumberConversionException e) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "StAXXMLReader.InvalidID", new Object[]{id}));
        }
        Object replacedObject = this.deserializedObjects.put(integer, object);
        if (null != replacedObject) {
            throw new Handler.XMLParseException(RB.getString((Object)this, "StAXXMLReader.UniqueID", new Object[]{id}));
        }
    }

    @Override
    public String getXML() {
        return this.xml;
    }

    @Override
    public String getCurrentNodeStr() {
        try {
            return this.generator.getCurrentNodeStr();
        }
        catch (Exception e) {
            return null;
        }
    }
}

