/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import javax.xml.stream.XMLStreamException;

public class StringHandler
extends AbstractHandler {
    public StringHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return obj instanceof String || obj instanceof char[];
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        if (obj instanceof char[]) {
            generator.addText(new String((char[])obj));
        } else {
            generator.addText(String.valueOf(obj).trim());
        }
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "STRING".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class type, boolean useCustomeSerializer) throws Handler.XMLParseException {
        int eventType = reader.getEventType();
        if (eventType == 2) {
            return "";
        }
        if (eventType != 4) {
            throw new Handler.XMLParseException(RB.getString(this, "StringHandler.InvalidFormat"));
        }
        String text = reader.getText();
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(e);
        }
        return text;
    }

    @Override
    public String getType(Object obj) {
        return "STRING";
    }
}

