/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.log.CFLogs;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import coldfusion.xml.rpc.CFCInvocationException;
import coldfusion.xml.rpc.TypeConverter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class StructHandler
extends AbstractHandler {
    public StructHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return Map.class.isAssignableFrom(obj.getClass());
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        generator.addStartElement("STRUCT");
        Integer idRef = generator.getIDRef(obj);
        Map map = (Map)obj;
        if (null == idRef) {
            int generatedId = generator.addSerializedObject(map);
            generator.addAttribute("ID", String.valueOf(generatedId));
            Set entrySet = map.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                generator.addStartElement("ENTRY");
                String key = String.valueOf(entry.getKey()).trim();
                generator.addAttribute("NAME", key);
                Object value = entry.getValue();
                Handler serializer = this.registry.getSerializer(value);
                generator.addAttribute("TYPE", serializer.getType(value));
                serializer.serialize(generator, value, useCustomSerializer);
                generator.addEndElement();
            }
        } else {
            generator.addAttribute("IDREF", String.valueOf(idRef));
        }
        generator.addEndElement();
    }

    @Override
    public String getType(Object obj) {
        return "STRUCT";
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "STRUCT".equalsIgnoreCase(type);
    }

    @Override
    public Object deserialize(XMLReader reader, Class datatype, boolean useCustomeSerializer) throws Handler.XMLParseException {
        Map<String, Object> deserializedMap = new HashMap();
        try {
            int eventType = reader.getEventType();
            if (1 != eventType || !reader.getLocalName().equalsIgnoreCase("STRUCT")) {
                throw new Handler.XMLParseException(RB.getString((Object)this, "StructHandler.InvalidStartElement", new Object[]{reader.getLocalName()}));
            }
            int attributeCount = reader.getAttributeCount();
            String idRef = null;
            String id = null;
            for (int i = 0; i < attributeCount; ++i) {
                String attributeLocalName = reader.getAttributeLocalName(i);
                if ("IDREF".equalsIgnoreCase(attributeLocalName)) {
                    idRef = reader.getAttributeValue(i).trim();
                    continue;
                }
                if ("ID".equalsIgnoreCase(attributeLocalName)) {
                    id = reader.getAttributeValue(i).trim();
                    continue;
                }
                CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
            }
            if (null == idRef) {
                reader.addDeSerializedObject(id, deserializedMap);
                int next = reader.next();
                while (!(next == 2 && "STRUCT".equalsIgnoreCase(reader.getLocalName()))) {
                    String localName = reader.getLocalName();
                    if (!"ENTRY".equalsIgnoreCase(localName)) {
                        throw new Handler.XMLParseException(RB.getString((Object)this, "StructHandler.ExpectedEntry", new Object[]{localName}));
                    }
                    String entryName = null;
                    String type = null;
                    attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        String attributeLocalName = reader.getAttributeLocalName(i);
                        if ("NAME".equalsIgnoreCase(attributeLocalName)) {
                            entryName = reader.getAttributeValue(i);
                            continue;
                        }
                        if ("TYPE".equalsIgnoreCase(attributeLocalName)) {
                            type = reader.getAttributeValue(i);
                            continue;
                        }
                        CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
                    }
                    if (null == entryName || entryName.trim().length() == 0) {
                        throw new Handler.XMLParseException(RB.getString(this, "StructHandler.NameIsMandatory"));
                    }
                    if (null == type || type.trim().length() == 0) {
                        throw new Handler.XMLParseException(RB.getString(this, "StructHandler.TypeIsMandatory"));
                    }
                    Handler handler = this.registry.getDeserializer(type);
                    reader.next();
                    Object deserialized = handler.deserialize(reader, Object.class, useCustomeSerializer);
                    deserializedMap.put(entryName, deserialized);
                    next = reader.next();
                }
            } else {
                Object referencedObject = reader.getReferencedObject(idRef);
                if (!(referencedObject instanceof Map)) {
                    throw new Handler.XMLParseException(RB.getString((Object)this, "StructHandler.InvalidReferencedObject", new Object[]{this.registry.getSerializer(referencedObject).getType(referencedObject)}));
                }
                deserializedMap = (Map)referencedObject;
                reader.next();
            }
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(RB.getString(this, "Handler.GeneralMessage"), e);
        }
        try {
            return TypeConverter.convertIn(deserializedMap);
        }
        catch (CFCInvocationException e) {
            throw new Handler.XMLParseException(e);
        }
    }
}

