/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.scheduling.RunnableFactory;
import coldfusion.scheduling.ThreadPoolInterface;
import coldfusion.scheduling.WorkerThread;
import coldfusion.security.SandBoxSecurityContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ThreadPool
extends ThreadGroup
implements ThreadPoolInterface,
RunnableFactory {
    protected RunnableFactory factory;
    protected int minHandlers;
    protected int activeHandlers;
    protected int maxHandlers;
    protected int listeningMetric;
    protected int listening;
    protected int justSpawned;
    protected int busyMetric;
    protected int busy;
    protected int waitingMetric;
    protected int delayMetric;
    protected int idleMetric;
    protected int totalMetric;
    protected int total;
    protected int gotDelayed;
    protected int gotDropped;
    private long handlerId = 0L;
    private boolean shutdown = false;
    private SandBoxSecurityContext threadSandboxContext;

    public ThreadPool(String groupName, RunnableFactory factory) {
        this(groupName, factory, SandBoxSecurityContext.INHERITED);
    }

    public ThreadPool(String groupName, RunnableFactory factory, SandBoxSecurityContext threadSandboxContext) {
        super(groupName);
        this.factory = factory;
        this.threadSandboxContext = threadSandboxContext;
        this.listening = 0;
        this.justSpawned = 0;
        this.busy = 0;
        for (int i = 0; i < this.minHandlers; ++i) {
            this.spawnHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void spawnHandler() {
        String threadName = this.getName() + "-" + this.handlerId;
        Thread t = this.getNewThread(threadName);
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            ++this.handlerId;
            ++this.total;
            ++this.justSpawned;
        }
        t.start();
    }

    private Thread getNewThread(final String threadName) {
        if (System.getSecurityManager() != null && this.threadSandboxContext == SandBoxSecurityContext.PRIVILEGED) {
            final ThreadPool that = this;
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return new WorkerThread((ThreadGroup)that, threadName);
                }
            });
        }
        return new WorkerThread((ThreadGroup)this, threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupHandler(WorkerThread th) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            --this.total;
            if (this.total < this.minHandlers && !this.shutdown) {
                this.spawnHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable createRunnable() throws InterruptedException {
        WorkerThread wt = (WorkerThread)Thread.currentThread();
        Runnable r = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (wt.isNew) {
                --this.justSpawned;
                wt.isNew = false;
            }
            ++this.listening;
        }
        try {
            r = this.factory.createRunnable();
            if (r != null && wt.isInterrupted()) {
                this.factory.destroyRunnable(r, 3);
                r = null;
                throw new InterruptedException();
            }
        }
        finally {
            boolean destroy = false;
            ThreadPool threadPool2 = this;
            synchronized (threadPool2) {
                --this.listening;
                int willListen = this.listening + this.justSpawned;
                if (r != null) {
                    if (willListen < this.minHandlers && this.total < this.maxHandlers) {
                        this.spawnHandler();
                    }
                } else if (willListen >= this.minHandlers) {
                    throw new InterruptedException();
                }
            }
        }
        return r;
    }

    @Override
    public Runnable swapRunnable(Runnable r) throws InterruptedException {
        WorkerThread currentThread = (WorkerThread)Thread.currentThread();
        if (currentThread.isShutdown()) {
            this.factory.destroyRunnable(r, 2);
            throw new InterruptedException();
        }
        if ((r = this.factory.swapRunnable(r)) != null && currentThread.isShutdown()) {
            this.factory.destroyRunnable(r, 2);
            throw new InterruptedException();
        }
        return r;
    }

    @Override
    public void destroyRunnable(Runnable r, int reason) {
        this.factory.destroyRunnable(r, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Runnable r) {
        boolean delayed = false;
        long before = System.currentTimeMillis();
        WorkerThread wt = (WorkerThread)Thread.currentThread();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            while (this.busy >= this.activeHandlers) {
                delayed = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.busy;
        }
        try {
            wt.markStart(before);
            r.run();
        }
        finally {
            threadPool = this;
            synchronized (threadPool) {
                if (--this.busy < 0) {
                    this.busy = 0;
                }
                this.notifyAll();
            }
        }
    }

    public void setMinThreads(int i) {
        if (i < 1) {
            i = 1;
        }
        if (i > this.maxHandlers) {
            i = this.maxHandlers;
        }
        while (this.minHandlers < i) {
            ++this.minHandlers;
            if (this.listening >= this.minHandlers || this.total > this.maxHandlers) continue;
            this.spawnHandler();
        }
    }

    public void setActiveThreads(int i) {
        if (i < 1) {
            i = 1;
        }
        if (i > this.maxHandlers) {
            i = this.maxHandlers;
        }
        this.activeHandlers = i;
    }

    public void setMaxThreads(int i) {
        if (i < 1) {
            i = 1;
        }
        if (this.minHandlers > i) {
            this.minHandlers = i;
        }
        if (this.activeHandlers > i) {
            this.activeHandlers = i;
        }
        this.maxHandlers = i;
    }

    public synchronized void shutdown() {
        Thread[] list = new Thread[this.activeCount()];
        int nHandlers = this.enumerate(list, false);
        this.shutdown = true;
        while (nHandlers-- > 0) {
            list[nHandlers].interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allThreadsBusy() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.busy >= this.maxHandlers;
            {
            }
        }
    }
}

