/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.security.SandBoxFolderPermissions;
import coldfusion.security.SandBoxHelper;
import coldfusion.server.ServiceFactory;
import coldfusion.vfs.VFSFileFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthorizedUser {
    private static final String FILE_PERMISSION_KLASS = "java.io.FilePermission";
    private static final String DATA_SOURCE_PERMISSION_KLASS = "coldfusion.sql.DataSourcePermission";
    private static final String WILDCARD_STAR = "*";
    private static final String ACTION = "ACTION";
    private static final String TARGET = "TARGET";
    private static final String KLASS = "CLASS";
    private static final String FILENAME = "FILENAME";
    public String username;
    public String password;
    public boolean allowclientcertauth;
    public String description;
    public String salt;
    public List<String> enabledds = new ArrayList<String>();
    public List<Struct> filepermissions = new ArrayList<Struct>();
    public List sandboxes = new ArrayList();
    public List roles;
    public boolean isLdap;
    public boolean isSaml;
    public boolean isGroup;
    private static final String WILDCARD = "<<ALL FILES>>";

    public AuthorizedUser(Map user, boolean detailSandboxes) {
        this.username = user.get("username").toString();
        this.isLdap = (Boolean)user.get("isLdap");
        this.isSaml = (Boolean)user.get("isSaml");
        this.isGroup = (Boolean)user.get("isGroup");
        if (user.containsKey("password") && user.get("password") != null && !user.get("password").toString().isEmpty()) {
            this.password = user.get("password").toString();
        }
        if (user.containsKey("description")) {
            this.description = user.get("description").toString();
        }
        if (user.containsKey("salt") && user.get("salt") != null) {
            this.salt = user.get("salt").toString();
        }
        if (user.get("sandboxes") != null) {
            List sands = (List)user.get("sandboxes");
            this.sandboxes = new ArrayList(sands);
            if (detailSandboxes) {
                this.getDetailsFromSandbox();
            }
        }
        if (user.get("roles") != null) {
            List rls = (List)user.get("roles");
            this.roles = new ArrayList(rls);
        }
        if (user.containsKey("allowclientcertauth")) {
            this.allowclientcertauth = Cast._boolean(user.get("allowclientcertauth"));
        }
    }

    public SandBoxFolderPermissions getAuthorizedFolders() {
        if (!ServiceFactory.getSecurityService().isSandboxSecurityEnabled()) {
            return null;
        }
        SandBoxFolderPermissions folders = new SandBoxFolderPermissions();
        if (this.sandboxes != null) {
            folders.add(this.sandboxes);
        }
        return folders;
    }

    public Map getAuthorizedDatasources() {
        Map allDbs = ServiceFactory.getDataSourceService().getDatasources();
        if (!ServiceFactory.getSecurityService().isSandboxSecurityEnabled()) {
            return allDbs;
        }
        HashMap allowedDbs = new HashMap();
        if (this.sandboxes != null) {
            List securityDbs = SandBoxHelper.findSecuritySettings(this.sandboxes, DATA_SOURCE_PERMISSION_KLASS);
            for (int j = 0; j < securityDbs.size(); ++j) {
                String tmpTarget = (String)((Map)securityDbs.get(j)).get(TARGET);
                if (tmpTarget == null) continue;
                if (tmpTarget.equals(WILDCARD_STAR)) {
                    return allDbs;
                }
                if (!allDbs.containsKey(tmpTarget)) continue;
                allowedDbs.put(tmpTarget, allDbs.get(tmpTarget));
            }
        }
        return allowedDbs;
    }

    private void getDetailsFromSandbox() {
        Map allDbs = ServiceFactory.getDataSourceService().getDatasources();
        List securityDbs = SandBoxHelper.findSecuritySettings(this.sandboxes, DATA_SOURCE_PERMISSION_KLASS);
        for (int j = 0; j < securityDbs.size(); ++j) {
            String tmpTarget = (String)((Map)securityDbs.get(j)).get(TARGET);
            if (tmpTarget == null) continue;
            if (tmpTarget.equals(WILDCARD_STAR)) {
                this.enabledds.add(WILDCARD_STAR);
                break;
            }
            if (!allDbs.containsKey(tmpTarget)) continue;
            this.enabledds.add(tmpTarget);
        }
        List folders = SandBoxHelper.findSecuritySettings(this.sandboxes, FILE_PERMISSION_KLASS);
        for (int i = 0; i < folders.size(); ++i) {
            Map folder = (Map)folders.get(i);
            String target = folder.get(TARGET).toString();
            if (target == null || target.length() <= 0) continue;
            Struct file = new Struct();
            target = target.replace("<", "&lt;");
            target = target.replace(">", "&gt;");
            file.put(FILENAME, (Object)target);
            file.put(ACTION, (Object)folder.get(ACTION).toString());
            this.filepermissions.add(file);
        }
    }

    protected static List constructSandbox(List<String> enabledDs, List<Struct> filePermissions) {
        Map allDbs = ServiceFactory.getDataSourceService().getDatasources();
        ArrayList<Struct> grantedSandbox = new ArrayList<Struct>();
        if (enabledDs != null && enabledDs.size() > 0) {
            if (enabledDs.contains(WILDCARD_STAR)) {
                Struct dsPermission = new Struct();
                dsPermission.put(KLASS, (Object)DATA_SOURCE_PERMISSION_KLASS);
                dsPermission.put(TARGET, (Object)WILDCARD_STAR);
                dsPermission.put(ACTION, (Object)"");
                grantedSandbox.add(dsPermission);
            } else {
                for (String dsn : enabledDs) {
                    if (!allDbs.containsKey(dsn)) continue;
                    Struct dsPermission = new Struct();
                    dsPermission.put(KLASS, (Object)DATA_SOURCE_PERMISSION_KLASS);
                    dsPermission.put(TARGET, (Object)dsn);
                    dsPermission.put(ACTION, (Object)"");
                    grantedSandbox.add(dsPermission);
                }
            }
        }
        if (filePermissions != null && filePermissions.size() > 0) {
            for (Struct fileObj : filePermissions) {
                String fname;
                if (fileObj == null || (fname = (String)fileObj.get(FILENAME)).length() <= 0) continue;
                String actions = (String)fileObj.get(ACTION);
                boolean isVFile = VFSFileFactory.checkIfVFile(fname);
                if (isVFile) continue;
                Struct filePermission = new Struct();
                filePermission.put(KLASS, (Object)FILE_PERMISSION_KLASS);
                filePermission.put(TARGET, (Object)fname);
                filePermission.put(ACTION, (Object)actions);
                grantedSandbox.add(filePermission);
            }
        }
        return grantedSandbox;
    }
}

