/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.Cast;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class ESAPIUtils {
    private static final String DN = "dn";
    private static final String LDAP = "ldap";
    private static final String XPATH = "xpath";
    private static final String XMLATTRIBUTE = "xmlattribute";
    private static final String XML = "xml";
    private static final String HTML = "html";
    private static final String HTMLATTRIBUTE = "htmlattribute";
    private static final String URL = "url";
    private static final String URL_20 = "url%20";
    private static final String JAVASCRIPT = "javascript";
    private static final String CSS = "css";
    private static final String NONE = "none";
    private static final String ANTISAMY_BASIC_XML = "antisamy-basic.xml";
    private static Encoder encoder;
    private static Validator validator;
    public static final String CFCONTAINER_ID_TYPE = "CFContainerID";
    public static final String GOOGLEMAPAPI = "GOOGLEMAPAPI";
    public static final String CFFORMSCRIPTSRC = "CFFORMSCRIPTSRC";
    public static final String ORMSEARCHDIR = "ORMSEARCHDIR";
    public static final String JSONPREFIX = "JSONPREFIX";
    private static List<String> validEncodingTypes;
    private static final Pattern[] exceptionMessagePattern;
    private static final String[] exceptionMessageLocKeys;

    static void loadESAPIUtils() {
        try {
            if (encoder == null) {
                encoder = ESAPI.encoder();
            }
            if (validator == null) {
                validator = ESAPI.validator();
            }
            validEncodingTypes = Arrays.asList(HTML, URL, HTMLATTRIBUTE, CSS, JAVASCRIPT, URL_20, XML, XMLATTRIBUTE, XPATH, LDAP, DN, NONE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String decodeForHTML(String inputString) throws EncodingUtilException {
        if (inputString != null && inputString.length() > 0) {
            inputString = encoder.decodeForHTML(inputString);
        }
        return inputString;
    }

    public static String decodeFromBase64(String inputString) throws EncodingUtilException {
        if (inputString != null && inputString.length() > 0) {
            try {
                inputString = new String(encoder.decodeFromBase64(inputString));
            }
            catch (IOException e) {
                CFLogs.ESAPI_LOG.error(e);
                throw new DecodingUtilException();
            }
        }
        return inputString;
    }

    public static String decodeFromURL(String inputString) throws EncodingUtilException {
        if (inputString != null && inputString.length() > 0) {
            try {
                inputString = encoder.decodeFromURL(inputString);
            }
            catch (EncodingException e) {
                CFLogs.ESAPI_LOG.error(e);
                throw new EncodingUtilException();
            }
            catch (IntrusionException e) {
                throw ESAPIUtils.getLocalizedIntrusionException(e);
            }
        }
        return inputString;
    }

    public static String encodeForCSS(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForCSS(inputString);
        }
        return inputString;
    }

    public static String encodeForDN(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForDN(inputString);
        }
        return inputString;
    }

    public static String encodeForHTML(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForHTML(inputString);
        }
        return inputString;
    }

    public static String encodeForHTMLAttribute(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForHTMLAttribute(inputString);
        }
        return inputString;
    }

    public static String encodeForHTMLAttributeFilePath(String inputString) {
        if (inputString != null && inputString.length() > 0) {
            inputString = encoder.encodeForHTMLAttribute(inputString);
        }
        return inputString;
    }

    public static String encodeForHTMLFilePath(String inputString) throws EncodingUtilException {
        if (inputString != null && inputString.length() > 0) {
            inputString = encoder.encodeForHTML(inputString);
        }
        return inputString;
    }

    public static String encodeForJavaScript(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForJavaScript(inputString);
        }
        return inputString;
    }

    public static String encodeForLDAP(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForLDAP(inputString);
        }
        return inputString;
    }

    public static String encodeForURL(String inputString, boolean canonicalize) throws EncodingUtilException {
        if (inputString != null && inputString.length() > 0) {
            try {
                if (canonicalize) {
                    inputString = encoder.canonicalize(inputString, false);
                }
                inputString = encoder.encodeForURL(inputString);
            }
            catch (EncodingException e) {
                CFLogs.ESAPI_LOG.error(e);
                throw new EncodingUtilException();
            }
        }
        return inputString;
    }

    public static String encodeForXML(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForXML(inputString);
        }
        return inputString;
    }

    public static String encodeForXMLAttribute(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForXMLAttribute(inputString);
        }
        return inputString;
    }

    public static String encodeForXPath(String inputString, boolean canonicalize) {
        if (inputString != null && inputString.length() > 0) {
            if (canonicalize) {
                inputString = encoder.canonicalize(inputString, false);
            }
            inputString = encoder.encodeForXPath(inputString);
        }
        return inputString;
    }

    public static String encodeFor(Object type, String input) {
        if (type == null) {
            return input;
        }
        if (type instanceof String) {
            return ESAPIUtils.encodeFor((String)type, input, false);
        }
        if (type instanceof Map) {
            return ESAPIUtils._encodeFor((Map)type, input);
        }
        return input;
    }

    private static String _encodeFor(Map typeMap, String input) {
        String encodeType = (String)typeMap.get("type");
        Object canonicalize = typeMap.get("canonicalize");
        if (canonicalize == null) {
            return ESAPIUtils.encodeFor(encodeType, input, false);
        }
        return ESAPIUtils.encodeFor(encodeType, input, Cast._boolean(canonicalize));
    }

    private static String encodeFor(String type, String input, boolean canonicalize) {
        if (type == null || type.trim().isEmpty() || type.equalsIgnoreCase(NONE)) {
            return input;
        }
        if (type.equalsIgnoreCase(HTML)) {
            return ESAPIUtils.encodeForHTML(input, canonicalize);
        }
        if (type.equalsIgnoreCase(HTMLATTRIBUTE)) {
            return ESAPIUtils.encodeForHTMLAttribute(input, canonicalize);
        }
        if (type.equalsIgnoreCase(URL)) {
            return ESAPIUtils.encodeForURL(input, canonicalize);
        }
        if (type.equalsIgnoreCase(URL_20)) {
            return ESAPIUtils.encodeForURL(input, canonicalize).replace("+", "%20");
        }
        if (type.equalsIgnoreCase(JAVASCRIPT)) {
            return ESAPIUtils.encodeForJavaScript(input, canonicalize);
        }
        if (type.equalsIgnoreCase(CSS)) {
            return ESAPIUtils.encodeForCSS(input, canonicalize);
        }
        if (type.equalsIgnoreCase(XML)) {
            return ESAPIUtils.encodeForXML(input, canonicalize);
        }
        if (type.equalsIgnoreCase(XMLATTRIBUTE)) {
            return ESAPIUtils.encodeForXMLAttribute(input, canonicalize);
        }
        if (type.equalsIgnoreCase(XPATH)) {
            return ESAPIUtils.encodeForXPath(input, canonicalize);
        }
        if (type.equalsIgnoreCase(LDAP)) {
            return ESAPIUtils.encodeForLDAP(input, canonicalize);
        }
        if (type.equalsIgnoreCase(DN)) {
            return ESAPIUtils.encodeForDN(input, canonicalize);
        }
        throw new InvalidEncodingTypeException(type);
    }

    public static void validateEncodingType(String type) {
        if (type != null && !validEncodingTypes.contains(type.toLowerCase())) {
            throw new InvalidEncodingTypeException(type);
        }
    }

    public static List<String> getValidEncodingTypes() {
        return validEncodingTypes;
    }

    public static String getValidateInput(String input, String type, int maxLength) throws ValidationUtilException {
        if (input != null && type != null) {
            ValidationErrorList errors = new ValidationErrorList();
            String validInput = validator.getValidInput(type, input, type, maxLength, false, errors);
            ArrayList errorList = (ArrayList)errors.errors();
            if (errorList != null && errorList.size() > 0) {
                for (ValidationException validationException : errorList) {
                    CFLogs.ESAPI_LOG.error((Throwable)validationException);
                }
                throw new ValidationUtilException();
            }
            return validInput;
        }
        throw new ValidationUtilException();
    }

    private static IntrusionException getLocalizedIntrusionException(IntrusionException e) {
        for (int i = 0; i < exceptionMessagePattern.length; ++i) {
            Matcher matcher = exceptionMessagePattern[i].matcher(e.getLogMessage());
            if (!matcher.matches()) continue;
            int argsLength = matcher.groupCount();
            Object[] args = new Object[argsLength];
            for (int j = 1; j <= argsLength; ++j) {
                args[j - 1] = matcher.group(j);
            }
            return new IntrusionException(RB.getString(ESAPIUtils.class, "InputValidationFailure"), RB.getString(ESAPIUtils.class, exceptionMessageLocKeys[i], args));
        }
        return e;
    }

    public static String canonicalize(String inputString, boolean restrictMultiple, boolean restrictMixed, boolean throwOnError) {
        if (inputString != null && inputString.length() > 0) {
            try {
                inputString = encoder.canonicalize(inputString, restrictMultiple, restrictMixed);
            }
            catch (Exception e) {
                if (!throwOnError) {
                    inputString = "";
                }
                if (e instanceof IntrusionException) {
                    throw ESAPIUtils.getLocalizedIntrusionException((IntrusionException)((Object)e));
                }
                throw new CanonicalizationException(e, e.getMessage());
            }
        }
        return inputString;
    }

    private static File resolvePolicyFile(String policyFile) {
        String baseDir;
        File configFile;
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (policyFile == null || policyFile != null && ((String)policyFile).isEmpty()) {
            if (appScope != null) {
                ApplicationSettings appSettings = appScope.getApplicationSettings();
                policyFile = appSettings.getAntiSamyPolicyFile();
            }
            if (policyFile == null || policyFile != null && ((String)policyFile).isEmpty()) {
                policyFile = ServiceFactory.getRuntimeService().getLibDir() + File.separator + ANTISAMY_BASIC_XML;
            }
        }
        if (!(configFile = new File((String)policyFile)).isAbsolute() && appScope != null && (baseDir = appScope.getApplicationPath()) != null && baseDir.length() > 0) {
            if ((baseDir.endsWith(".cfc") || baseDir.endsWith(".cfm")) && baseDir.length() > 16) {
                baseDir = baseDir.substring(0, baseDir.length() - 16);
            }
            if (((String)policyFile).startsWith("/") || ((String)policyFile).startsWith("\\")) {
                policyFile = ((String)policyFile).substring(1, ((String)policyFile).length());
            }
            if (!(configFile = new File((String)(policyFile = baseDir + File.separator + (String)policyFile))).exists()) {
                throw new PolicyFileException((String)policyFile);
            }
        }
        return configFile;
    }

    public static boolean isSafeHTML(String input, String policyFile) {
        boolean isValid = false;
        File policyFileObj = ESAPIUtils.resolvePolicyFile(policyFile);
        try {
            Policy policy = Policy.getInstance((File)policyFileObj);
            AntiSamy antiSamy = new AntiSamy();
            CleanResults results = antiSamy.scan(input, policy);
            if (results != null) {
                if (results.getNumberOfErrors() <= 0) {
                    isValid = true;
                } else {
                    StringBuilder msgs = new StringBuilder();
                    for (String msg : results.getErrorMessages()) {
                        if (msg == null) continue;
                        msgs.append(msg).append(" ");
                    }
                    CFLogs.ESAPI_LOG.error(msgs.toString());
                }
            }
        }
        catch (ScanException e) {
            throw new HTMLValidationException(e, RB.getString(ESAPIUtils.class, "ScanExceptionMsg") + e.getMessage());
        }
        catch (PolicyException e) {
            throw new HTMLValidationException(e, RB.getString(ESAPIUtils.class, "PolicyExceptionMsg") + e.getMessage());
        }
        return isValid;
    }

    public static String getSafeHTML(String input, String policyFile, boolean throwOnError) {
        String returnStr = "";
        File policyFileObj = ESAPIUtils.resolvePolicyFile(policyFile);
        try {
            Policy policy = Policy.getInstance((File)policyFileObj);
            AntiSamy antiSamy = new AntiSamy();
            CleanResults results = antiSamy.scan(input, policy);
            if (results != null) {
                returnStr = results.getCleanHTML();
            }
            if (throwOnError && results.getNumberOfErrors() > 0) {
                returnStr = "";
                StringBuilder msgs = new StringBuilder();
                for (String msg : results.getErrorMessages()) {
                    if (msg == null) continue;
                    msgs.append(msg).append("");
                }
                throw new HTMLValidationException(msgs.toString());
            }
        }
        catch (ScanException e) {
            throw new HTMLValidationException(e, RB.getString(ESAPIUtils.class, "ScanExceptionMsg") + e.getMessage());
        }
        catch (PolicyException e) {
            throw new HTMLValidationException(e, RB.getString(ESAPIUtils.class, "PolicyExceptionMsg") + e.getMessage());
        }
        return returnStr;
    }

    static {
        exceptionMessagePattern = new Pattern[]{Pattern.compile("Multiple \\((.*?)x\\) and mixed encoding \\((.*?)x\\) detected in (.*?)"), Pattern.compile("Multiple \\((.*?)x\\) encoding detected in (.*?)"), Pattern.compile("Mixed encoding \\((.*?)x\\) detected in (.*?)")};
        exceptionMessageLocKeys = new String[]{"InputValidationFailureBoth", "InputValidationFailureMultiple", "InputValidationFailureMixed"};
    }

    public static class DecodingUtilException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class EncodingUtilException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidEncodingTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public final String type;

        public InvalidEncodingTypeException(String type) {
            this.type = type;
        }
    }

    public static class ValidationUtilException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class CanonicalizationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public final String message;

        public CanonicalizationException(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }

    public static class PolicyFileException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public final String filename;

        public PolicyFileException(String filename) {
            this.filename = filename;
        }
    }

    public static class HTMLValidationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public final String message;

        public HTMLValidationException(String message) {
            this.message = message;
        }

        public HTMLValidationException(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }
}

