/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.security.KeyStoreUtils;
import coldfusion.security.SSLConfig;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtils {
    private static final String TLS = "TLS";

    public static SSLContext getSslContext(SSLConfig sslConfig) throws Exception {
        KeyManager[] keyManagers = SSLUtils.getKeyManagers(sslConfig);
        SSLContext sslContext = SSLContext.getInstance(sslConfig.getProtocol() != null ? sslConfig.getProtocol() : TLS);
        sslContext.init(sslConfig.getKeyStorePath() == null ? null : keyManagers, sslConfig.getTrustStorePath() == null ? null : SSLUtils.getTrustManagers(sslConfig), null);
        return sslContext;
    }

    public static KeyManager[] getKeyManagers(SSLConfig sslConfig) throws Exception {
        KeyStore keyStore = KeyStoreUtils.getKeyStore(sslConfig.getKeyStorePath(), sslConfig.getKeyStoreType(), sslConfig.getKeyStorePassword(), sslConfig.getKeyStoreProvider());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, sslConfig.getKeyStorePassword() == null ? null : sslConfig.getKeyStorePassword().toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(SSLConfig sslConfig) throws Exception {
        KeyStore trustStore = KeyStoreUtils.getKeyStore(sslConfig.getTrustStorePath(), sslConfig.getTrustStoreType(), sslConfig.getTrustStorePassword(), sslConfig.getTrustStoreProvider());
        if (trustStore != null) {
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(trustStore);
            return trustFactory.getTrustManagers();
        }
        return null;
    }
}

