/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.security.SandBoxHelper;
import coldfusion.server.SystemInfo;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SandBoxFolderPermissions {
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String EXECUTE = "execute";
    public static final String DELETE = "delete";
    private static final String WILDCARD = "<<ALL FILES>>";
    private HashMap authorizedFolders = new HashMap();
    private boolean authorizedForAll = false;
    private Set compareFolderCache = new HashSet();

    public void add(Object sandbox) {
        List folders = SandBoxHelper.findSecuritySettings(sandbox, "java.io.FilePermission");
        for (int i = 0; i < folders.size(); ++i) {
            Map folder = (Map)folders.get(i);
            Object target = folder.get("TARGET").toString();
            if (((String)target).equalsIgnoreCase(WILDCARD)) {
                this.authorizedForAll = true;
                continue;
            }
            if (((String)target).endsWith("/*") || ((String)target).endsWith("\\*")) {
                try {
                    target = ((String)target).substring(0, ((String)target).length() - 2);
                    target = VFSFileFactory.getFileObject((String)target).getCanonicalPath();
                }
                catch (IOException e) {
                    target = VFSFileFactory.getFileObject((String)target).getAbsolutePath();
                }
                target = (String)target + File.separator + "*";
            } else if (((String)target).endsWith("/-") || ((String)target).endsWith("\\-")) {
                try {
                    target = ((String)target).substring(0, ((String)target).length() - 2);
                    target = VFSFileFactory.getFileObject((String)target).getCanonicalPath();
                }
                catch (IOException e) {
                    target = VFSFileFactory.getFileObject((String)target).getAbsolutePath();
                }
                target = (String)target + File.separator + "-";
            } else {
                try {
                    target = VFSFileFactory.getFileObject((String)target).getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            List<String> permissions = Arrays.asList(folder.get("ACTION").toString().split(","));
            this.authorizedFolders.put(target, permissions);
        }
    }

    public boolean isAuthorized(File file) {
        if (this.authorizedForAll || this.compareFolderCache.contains(file)) {
            return true;
        }
        if (this.findMatchingFolder(file) != null) {
            this.compareFolderCache.add(file);
            return true;
        }
        return false;
    }

    public boolean isAuthorized(File file, String permission) {
        if (this.authorizedForAll) {
            return true;
        }
        List folderPermissions = this.findMatchingFolder(file);
        return folderPermissions != null && folderPermissions.contains(permission);
    }

    private List findMatchingFolder(File file) {
        String path;
        Iterator itr = this.authorizedFolders.keySet().iterator();
        File fileDirPath = file.isFile() ? file.getParentFile() : file;
        String string = path = SystemInfo.isWindows() ? fileDirPath.getPath().toLowerCase() : fileDirPath.getPath();
        while (itr.hasNext()) {
            Object key = itr.next();
            List folderInfo = (List)this.authorizedFolders.get(key);
            String folderPath = SystemInfo.isWindows() ? key.toString().toLowerCase() : key.toString();
            boolean recurse = false;
            char lastChar = folderPath.charAt(folderPath.length() - 1);
            if (lastChar == '-' || lastChar == '*') {
                folderPath = folderPath.substring(0, folderPath.length() - 1);
                String string2 = folderPath = SystemInfo.isWindows() ? folderPath.toLowerCase() : folderPath;
                if (lastChar == '-') {
                    recurse = true;
                }
            }
            if (path.length() <= folderPath.length()) {
                if (file.isDirectory() && this.compareFolderStartsWith(folderPath, path)) {
                    return folderInfo;
                }
                if (!fileDirPath.equals(new File(folderPath))) continue;
                return folderInfo;
            }
            if (!recurse || !this.compareFolderStartsWith(path, folderPath.substring(0, folderPath.length() - 1))) continue;
            return folderInfo;
        }
        return null;
    }

    private boolean compareFolderStartsWith(String fullPath, String startsWithPath) {
        if (fullPath.equals(startsWithPath)) {
            return true;
        }
        int sPathLength = startsWithPath.length();
        for (int i = 0; i < sPathLength; ++i) {
            if (i < sPathLength - 1) {
                if (fullPath.charAt(i) == startsWithPath.charAt(i)) continue;
                return false;
            }
            if (fullPath.charAt(i) == startsWithPath.charAt(i)) {
                return startsWithPath.charAt(i) == File.separatorChar || fullPath.charAt(i + 1) == File.separatorChar || fullPath.charAt(i + 1) == '\n';
            }
            return false;
        }
        return false;
    }
}

