/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.runtime.ClientScopeService;
import coldfusion.security.SecureProfileHelper;
import coldfusion.security.SecureProfileSetting;
import coldfusion.server.ConfigMap;
import coldfusion.server.DataSourceService;
import coldfusion.server.DebuggingService;
import coldfusion.server.MetricsService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import java.util.Map;
import java.util.Set;

public class SecureProfileOthersHelper
extends SecureProfileHelper {
    public SecureProfileOthersHelper(String dir) {
        super(dir);
    }

    protected static void populateOthersSettings(Map<String, SecureProfileSetting> settings) {
        try {
            settings.get("cfstat").setCurrentValue(String.valueOf(ServiceFactory.getMetricsService().getCfstatEnabled()));
        }
        catch (Exception e) {
            settings.get("cfstat").setCurrentValue("false");
        }
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        WebSocketService webSocketService = ServiceFactory.getWebsocketService();
        settings.get("uuidToken").setCurrentValue(String.valueOf(ServiceFactory.getClientScopeService().isUUIDEnabled()));
        settings.get("robust_enabled").setCurrentValue(String.valueOf(debuggingService != null && debuggingService.isRobustEnabled()));
        settings.get("startWebSocketService").setCurrentValue(String.valueOf(webSocketService != null && webSocketService.isWebSocketServiceEnabled()));
        settings.get("flashFallBack").setCurrentValue(String.valueOf(webSocketService != null && webSocketService.isFlashFallBackEnabled()));
        Map defaults = ServiceFactory.getDataSourceService().getDefaults();
        for (String key : settings.keySet()) {
            SecureProfileSetting setting = settings.get(key);
            if (!setting.getRefNeoFile().equalsIgnoreCase("neodriver")) continue;
            settings.get(key).setCurrentValue(String.valueOf(defaults.get(key)));
        }
    }

    protected static void setAllowedSQL(Map<String, SecureProfileSetting> settings, boolean secure, DataSourceService dsService) {
        Set<String> keys = settings.keySet();
        if (keys != null && !keys.isEmpty()) {
            ConfigMap defaults = (ConfigMap)dsService.getDefaults();
            for (String string : keys) {
                String newValue;
                SecureProfileSetting setting = settings.get(string);
                if (!setting.getRefNeoFile().equalsIgnoreCase("neodriver")) continue;
                if (secure) {
                    boolean oldValue = (Boolean)defaults.get(string);
                    setting.setDefaultValue(String.valueOf(oldValue));
                    settings.put(string, setting);
                    newValue = setting.getSecureDefaultValue();
                } else {
                    newValue = setting.getDefaultValue();
                }
                defaults.put(string, (Object)Boolean.parseBoolean(newValue));
            }
            dsService.setDefaults(defaults);
        }
    }

    protected static void setCFStatEnableSetting(Map<String, SecureProfileSetting> settings, boolean secure, MetricsService metricService) {
        String newValue;
        SecureProfileSetting cfstatEnableSetting = settings.get("cfstat");
        if (secure) {
            boolean oldValue = metricService.getCfstatEnabled();
            cfstatEnableSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = cfstatEnableSetting.getSecureDefaultValue();
        } else {
            newValue = cfstatEnableSetting.getDefaultValue();
        }
        metricService.setCfstatEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setUUIDSetting(Map<String, SecureProfileSetting> settings, boolean secure, ClientScopeService clientService) {
        String newValue;
        SecureProfileSetting uuidSetting = settings.get("uuidToken");
        if (secure) {
            boolean oldValue = clientService.isUUIDEnabled();
            uuidSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = uuidSetting.getSecureDefaultValue();
        } else {
            newValue = uuidSetting.getDefaultValue();
        }
        clientService.setUUIDEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setRobustEnableSetting(Map<String, SecureProfileSetting> settings, boolean secure, DebuggingService debugService) {
        String newValue;
        SecureProfileSetting robustEnableSetting = settings.get("robust_enabled");
        if (secure) {
            boolean oldValue = debugService.isRobustEnabled();
            robustEnableSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = robustEnableSetting.getSecureDefaultValue();
        } else {
            newValue = robustEnableSetting.getDefaultValue();
        }
        debugService.setRobustEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setWSEnableSetting(Map<String, SecureProfileSetting> settings, boolean secure, WebSocketService wsService) {
        String newValue;
        SecureProfileSetting startWebsocketSetting = settings.get("startWebSocketService");
        if (secure) {
            boolean oldValue = wsService.isWebSocketServiceEnabled();
            startWebsocketSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = startWebsocketSetting.getSecureDefaultValue();
        } else {
            newValue = startWebsocketSetting.getDefaultValue();
        }
        wsService.setWebSocketServiceEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setFlashFallBack(Map<String, SecureProfileSetting> settings, boolean secure, WebSocketService wsService) {
        String newValue;
        SecureProfileSetting flashFallbackSetting = settings.get("flashFallBack");
        if (secure) {
            boolean oldValue = wsService.isFlashFallBackEnabled();
            flashFallbackSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = flashFallbackSetting.getSecureDefaultValue();
        } else {
            newValue = flashFallbackSetting.getDefaultValue();
        }
        wsService.setFlashFallBackEnabled(Boolean.parseBoolean(newValue));
    }
}

