/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.SecurityScopeTracker;
import coldfusion.runtime.SecurityTable;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class UserUtils {
    public static final String getAuthUser() {
        String authUser = UserUtils.cflogin_GetAuthUser();
        if (authUser.equals("")) {
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            authUser = ((HttpServletRequest)pageContext.getRequest()).getRemoteUser();
        }
        if (authUser == null) {
            authUser = "";
        }
        return authUser;
    }

    public static final boolean isUserInRole(Object role) {
        NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
        return UserUtils.cflogin_IsUserInRole(role) || ((HttpServletRequest)pageContext.getRequest()).isUserInRole(role.toString());
    }

    public static final boolean isUserInAnyRole(String roleList) {
        StringTokenizer tokens = new StringTokenizer(roleList, ",");
        while (tokens.hasMoreTokens()) {
            String role = tokens.nextToken().trim();
            if (!UserUtils.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    private static final String cflogin_GetAuthUserInternal() {
        SecurityTable tab = UserUtils.getAuthMapInternal();
        if (tab == null) {
            return "";
        }
        return tab.getUserName();
    }

    private static final boolean cflogin_IsUserInRoleInternal(Object role) {
        SecurityTable roleMap = UserUtils.getAuthMapInternal();
        if (roleMap == null) {
            return false;
        }
        List groups = UserUtils.getGroups(role);
        if (groups == null) {
            return false;
        }
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            if (roleMap.containsKey(itr.next())) continue;
            return false;
        }
        return true;
    }

    protected static final String getAuthUserInternal() {
        String authUser = UserUtils.cflogin_GetAuthUserInternal();
        if (authUser.equals("")) {
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            authUser = ((HttpServletRequest)pageContext.getRequest()).getRemoteUser();
        }
        if (authUser == null) {
            authUser = "";
        }
        return authUser;
    }

    protected static final boolean isUserInRoleInternal(Object role) {
        NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
        return UserUtils.cflogin_IsUserInRoleInternal(role) || ((HttpServletRequest)pageContext.getRequest()).isUserInRole(role.toString());
    }

    protected static final boolean isUserInAnyRoleInternal(String roleList) {
        StringTokenizer tokens = new StringTokenizer(roleList, ",");
        while (tokens.hasMoreTokens()) {
            String role = tokens.nextToken().trim();
            if (!UserUtils.isUserInRoleInternal(role)) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isUserInRoleListInternal(List roles) {
        boolean isInList = false;
        for (int i = 0; i < roles.size(); ++i) {
            if (!UserUtils.isUserInRoleInternal(roles.get(i))) continue;
            isInList = true;
            break;
        }
        return isInList;
    }

    protected static SecurityTable getAuthMapInternal() {
        SecurityTable stab = ServiceFactory.getSecurityService().getSecurityState();
        if (stab == null) {
            return UserUtils.getAuthMapFromKey();
        }
        return stab;
    }

    public static final boolean isUserInRoleList(List roles) {
        boolean isInList = false;
        for (int i = 0; i < roles.size(); ++i) {
            if (!UserUtils.isUserInRole(roles.get(i))) continue;
            isInList = true;
            break;
        }
        return isInList;
    }

    private static final boolean cflogin_IsUserInRole(Object role) {
        SecurityTable roleMap = UserUtils.getAuthMap();
        if (roleMap == null) {
            return false;
        }
        List groups = UserUtils.getGroups(role);
        if (groups == null) {
            return false;
        }
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            if (roleMap.containsKey(itr.next())) continue;
            return false;
        }
        return true;
    }

    private static List getGroups(Object groups) {
        ArrayList<Object> _groups = new ArrayList<Object>(25);
        if (groups instanceof String) {
            StringTokenizer stok = new StringTokenizer((String)groups, ",");
            while (stok.hasMoreElements()) {
                _groups.add(stok.nextElement());
            }
            return _groups;
        }
        if (groups instanceof List) {
            return (List)groups;
        }
        return null;
    }

    private static final String cflogin_GetAuthUser() {
        SecurityTable tab = UserUtils.getAuthMap();
        if (tab == null) {
            return "";
        }
        return tab.getUserName();
    }

    private static final SecurityTable getAuthMap() {
        FusionContext current = FusionContext.getCurrent();
        boolean isAdminAPI = current.isAdminAPI();
        SecurityTable stab = null;
        if (isAdminAPI) {
            stab = ServiceFactory.getSecurityService().getSecurityState();
            if (stab == null) {
                return UserUtils.getAuthMapFromKey();
            }
            return stab;
        }
        return UserUtils.getAuthMapFromKey();
    }

    private static SecurityTable getAuthMapFromKey() {
        FusionContext current = FusionContext.getCurrent();
        SecurityTable stab = current.getSecureTable();
        if (stab == null) {
            NeoPageContext pageContext = current.pageContext;
            stab = SecurityScopeTracker.getInstance().getSecurity(pageContext);
            if (stab == null) {
                stab = SecurityScopeTracker.getInstance().getSecurityTableFromSession(pageContext);
            }
            if (stab != null) {
                current.setSecureTable(stab);
            }
        }
        return stab;
    }

    public static final String getUserRoles() {
        SecurityTable tab = UserUtils.getAuthMap();
        if (tab == null) {
            return "";
        }
        StringBuffer roleListBuf = new StringBuffer(4);
        String comma = "";
        for (String role : tab.keySet()) {
            roleListBuf.append(comma).append(role);
            comma = ",";
        }
        return roleListBuf.toString();
    }
}

