/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.security.WildcardPermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class WildcardPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient boolean wildcard = false;
    protected transient TreeSet taglist = null;
    protected transient String tag = null;

    public WildcardPermission(String name) {
        super(name);
        this.init(name);
    }

    public WildcardPermission(String name, String actions) {
        super(name);
        this.init(name);
    }

    private void init(String name) {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("name can't be null or empty");
        }
        if ("*".equals(name)) {
            this.wildcard = true;
            this.taglist = null;
            this.tag = null;
        } else if (name.startsWith("*-") && name.length() > 2) {
            this.wildcard = true;
            this.tag = null;
            if (this.taglist == null) {
                this.taglist = new TreeSet();
            } else {
                this.taglist.clear();
            }
            StringTokenizer tokens = new StringTokenizer(name.substring(2), ",");
            while (tokens.hasMoreTokens()) {
                this.taglist.add(tokens.nextToken());
            }
        } else if (name.indexOf("*") == -1 && name.indexOf(",") == -1) {
            this.wildcard = false;
            this.taglist = null;
            this.tag = name;
        } else {
            throw new IllegalArgumentException("wrong format: * or *-comma-separated list or single token");
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null || p.getClass() != this.getClass()) {
            return false;
        }
        WildcardPermission that = (WildcardPermission)p;
        if (this.wildcard && this.taglist == null) {
            return true;
        }
        if (this.wildcard && this.taglist != null) {
            if (that.wildcard && this.taglist == null) {
                return false;
            }
            if (that.wildcard && that.taglist != null) {
                Iterator i = that.taglist.iterator();
                while (i.hasNext()) {
                    if (this.taglist.contains(i.next())) continue;
                    return false;
                }
                return true;
            }
            return !this.taglist.contains(that.getName());
        }
        if (that.wildcard && this.taglist == null) {
            return false;
        }
        if (that.wildcard && this.taglist != null) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WildcardPermission tp = (WildcardPermission)obj;
        return this.getName().equals(tp.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new WildcardPermissionCollection();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }
}

