/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.compiler.validation.ValidationResultCollector;
import coldfusion.log.CFLogs;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerError;
import coldfusion.securityanalyzer.SecurityAnalyzerConfig;
import coldfusion.securityanalyzer.SecurityAnalyzerServlet;
import coldfusion.securityanalyzer.SecurityAnalyzerUtils;
import coldfusion.securityanalyzer.rules.CSRFRule;
import coldfusion.securityanalyzer.rules.CookieRule;
import coldfusion.securityanalyzer.rules.FileinjectionRule;
import coldfusion.securityanalyzer.rules.FileuploadRule;
import coldfusion.securityanalyzer.rules.GetvspostRule;
import coldfusion.securityanalyzer.rules.LocationRule;
import coldfusion.securityanalyzer.rules.PasswordRule;
import coldfusion.securityanalyzer.rules.SqlRule;
import coldfusion.securityanalyzer.rules.UnnamedappRule;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.securityanalyzer.rules.XssRule;
import coldfusion.util.RB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CFMLSecurityAnalyzerValidator
extends JJTreeVisitor
implements ValidationResultCollector {
    private List<CFMLValidationException> errors = new ArrayList<CFMLValidationException>();
    private SecurityAnalyzerConfig config;
    private Set<String> invalidFiles = new HashSet<String>();
    private Set<String> cannotparseFiles = new HashSet<String>();
    private List<CFMLSecurityAnalyzerError> ignorelist;
    private boolean testing = false;
    private boolean nexttestcasepass = true;
    private String nexttestcasekey = "";

    public CFMLSecurityAnalyzerValidator(SecurityAnalyzerConfig config, List<CFMLSecurityAnalyzerError> ignores) {
        this.config = config;
        this.ignorelist = ignores;
        this.errors = Collections.synchronizedList(this.errors);
    }

    public SecurityAnalyzerConfig getConfig() {
        return this.config;
    }

    public void setConfig(SecurityAnalyzerConfig config) {
        this.config = config;
    }

    @Override
    public void visit(TagNode tagNode) {
        try {
            if (this.applyRule("sqlinjection")) {
                SqlRule.validateCfquerySqlInjection(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("xss") || this.applyRule("htmltopdfxss")) {
                XssRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("csrf")) {
                CSRFRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("getvspost")) {
                GetvspostRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("cookiesvalidations")) {
                CookieRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("cflocationvalidations")) {
                LocationRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("passwords")) {
                PasswordRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("fileupload")) {
                FileuploadRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("fileinjection")) {
                FileinjectionRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("unnamedapp")) {
                UnnamedappRule.validate(tagNode, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
    }

    @Override
    public void visit(ASTcfscriptStatement node) {
        try {
            if (this.applyRule("cookiesvalidations")) {
                CookieRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("unnamedapp")) {
                UnnamedappRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("passwords")) {
                PasswordRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
    }

    @Override
    public void visit(ASTfuncparams node) {
        try {
            if (this.applyRule("sqlinjection")) {
                SqlRule.validateQueryexecuteSqlInjection(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("fileinjection")) {
                FileinjectionRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("fileupload")) {
                FileuploadRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("passwords")) {
                PasswordRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("xss")) {
                XssRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
    }

    @Override
    public void visit(ASTpcdata node) {
        try {
            String b = node.buffer.toString().trim();
            if (b.contains("@cftestcase")) {
                String args = b.substring(12, b.length() - 1);
                String[] split = args.split(",");
                if (split[0].split("=")[1].equalsIgnoreCase("pass")) {
                    this.setNexttestcasepass(true);
                } else {
                    this.setNexttestcasepass(false);
                }
                if (split.length > 1) {
                    this.setNexttestcasekey(split[1].split("=")[1]);
                }
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("csrf")) {
                CSRFRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        try {
            if (this.applyRule("getvspost")) {
                GetvspostRule.validate(node, this);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
    }

    public boolean applyRule(String rulekey) {
        if (!this.config.getRuleslist().contains(rulekey)) {
            return false;
        }
        return SecurityAnalyzerServlet.PRIORITYMAP.get(rulekey) >= this.config.getPriority();
    }

    public List<CFMLSecurityAnalyzerError> getIgnorelist() {
        return this.ignorelist;
    }

    @Override
    public void collectValidationResult(CFMLValidationException error) {
        this.errors.add(error);
    }

    public void removeValidationResultForKey(String key) {
        for (int i = 0; i < this.errors.size(); ++i) {
            CFMLValidationException error = this.errors.get(i);
            if (!((CFMLSecurityAnalyzerError)error).getName().equals(key)) continue;
            this.errors.remove(i);
        }
    }

    public void collectInvalidFiles(String file) {
        this.invalidFiles.add(file);
    }

    public Set<String> getCannotParseFiles() {
        return this.cannotparseFiles;
    }

    public void collectCannotparseFiles(String file) {
        this.cannotparseFiles.add(file);
    }

    @Override
    public void reset() {
        this.errors.clear();
    }

    @Override
    public Collection<CFMLValidationException> getValidationResult() {
        return this.errors;
    }

    public Set<String> getInvalidFiles() {
        return this.invalidFiles;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public boolean isNexttestcasepass() {
        return this.nexttestcasepass;
    }

    public void setNexttestcasepass(boolean nexttestcasepass) {
        this.nexttestcasepass = nexttestcasepass;
    }

    public void setNexttestcasekey(String key) {
        this.nexttestcasekey = key;
    }

    public void collectValidationResult(String errorkey, String errormsg, VariableType type, String warningtype, Node node) {
        this.collectValidationResult(errorkey, errormsg, type, warningtype, node, true);
    }

    public void collectValidationResult(String errorkey, String errormsg, VariableType type, String warningtype, Node node, boolean showWiggly) {
        if (this.config.getType().equals("all") || warningtype.equals(this.config.getType())) {
            List<CFMLSecurityAnalyzerError> ignorelist = this.getIgnorelist();
            File filename = null;
            if (node != null) {
                filename = node.getPageFile();
            }
            CFMLSecurityAnalyzerError error = new CFMLSecurityAnalyzerError(errorkey, errormsg, filename, warningtype);
            if (null != node) {
                error.setLineNumbers(node);
                if (showWiggly) {
                    error.setColumnNumbers(node);
                } else {
                    error.setBeginColumn(-1);
                    error.setEndColumn(-1);
                    error.setLineNumbers(error.getBeginLine() + 1, error.getEndLine());
                }
                boolean isFuncParam = false;
                for (Node parent = node.jjtGetParent(); parent != null; parent = parent.jjtGetParent()) {
                    if (!(parent instanceof ASTfuncparams)) continue;
                    isFuncParam = true;
                    break;
                }
                if (isFuncParam && node.getStartToken().image != null && !"\"".equals(node.getStartToken().image)) {
                    error.endColumn = error.beginColumn + node.getStartToken().image.length();
                }
            }
            if (this.config.isLogcode()) {
                this.logCodeSnippet(filename, error);
            }
            if (type != null) {
                error.setReferencetype(type.getType());
                error.setVulnerablenode(type.getValue());
            }
            if (ignorelist == null || !ignorelist.contains(error)) {
                this.collectValidationResult(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCodeSnippet(File file, CFMLSecurityAnalyzerError error) {
        int sl = error.getBeginLine();
        int el = error.getEndLine();
        FileInputStream ins = null;
        BufferedReader reader = null;
        Object code = "";
        try {
            ins = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(ins);
            reader = new BufferedReader(isr);
            String line = "";
            int c = 0;
            while ((line = reader.readLine()) != null) {
                if (++c < sl || c > el) continue;
                code = (String)code + line;
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                SecurityAnalyzerUtils.logException(e, "warning");
            }
        }
        CFLogs.SECURITY_LOG.info("Security analyzer log - File : " + error.getFilename() + ",Error key : " + error.getName() + ",Error desc : " + error.getDescription() + ",Line numbers : " + sl + "-" + el + ",Code snippet : " + (String)code);
    }

    public void collectInvalidValidationResult(String key, boolean pass, Node node) {
        if (this.isTesting() && key.equalsIgnoreCase(this.nexttestcasekey)) {
            if (pass && !this.isNexttestcasepass()) {
                this.collectValidationResult(key, RB.getString(CFMLSecurityAnalyzerValidator.class, "ShouldFail"), null, "error", node);
            } else if (!pass && this.isNexttestcasepass()) {
                this.collectValidationResult(key, RB.getString(CFMLSecurityAnalyzerValidator.class, "ShouldPass"), null, "error", node);
            }
        }
    }
}

