/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SecurityAnalyzerFileFilter
implements FilenameFilter {
    private List<Pattern> patterns = new ArrayList<Pattern>();
    public static List<String> allowedExtensions = new ArrayList<String>();

    public SecurityAnalyzerFileFilter(String exclude) {
        if (null != exclude) {
            for (String ex : exclude.split(",")) {
                Pattern pattern = Pattern.compile(ex);
                this.patterns.add(pattern);
            }
        }
    }

    public static boolean isCFFile(String filename) {
        filename = filename.toLowerCase();
        boolean allow = false;
        for (String extension : allowedExtensions) {
            if (!filename.endsWith("." + extension)) continue;
            allow = true;
            break;
        }
        return allow;
    }

    @Override
    public boolean accept(File file, String filename) {
        if (new File(file + File.separator + filename).isDirectory()) {
            return true;
        }
        if (!SecurityAnalyzerFileFilter.isCFFile(filename)) {
            return false;
        }
        if (null == this.patterns) {
            return true;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(filename).matches()) continue;
            return false;
        }
        return true;
    }

    static {
        allowedExtensions.add("cfm");
        allowedExtensions.add("cfml");
        allowedExtensions.add("cfc");
    }
}

