/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTStructInitializer;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.runtime.Cast;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;

public class CookieRule {
    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String cookie;
        Node httponlyattr;
        String tagname = node.getTagName();
        if ("cfcookie".equalsIgnoreCase(tagname)) {
            RulesCommon.checkBooleanAttribute("cookiesvalidations", node, validator, "httponly", "error");
            RulesCommon.checkBooleanAttribute("cookiesvalidations", node, validator, "secure", "warning");
        } else if ("cfheader".equalsIgnoreCase(tagname) && null != (httponlyattr = node.getNamedAttribute("name")) && null != (cookie = ((ASTliteral)httponlyattr).tokens.get(0).toString()) && cookie.equalsIgnoreCase("set-cookie")) {
            boolean httponly = false;
            boolean secure = false;
            Node value = node.getNamedAttribute("value");
            Vector tokens = ((ASTliteral)value).tokens;
            String var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (t instanceof String) {
                    var = (String)t;
                    var = var.toLowerCase();
                }
                if (null == var) continue;
                if (var.contains("httponly")) {
                    httponly = true;
                }
                if (!var.contains("secure")) continue;
                secure = true;
            }
            if (!httponly) {
                validator.collectValidationResult("cookiesvalidations", RB.getString(CookieRule.class, "CookieNotSet.HTTP"), null, "error", value);
            }
            if (!secure) {
                validator.collectValidationResult("cookiesvalidations", RB.getString(CookieRule.class, "CookieNotSet.SECURE"), null, "warning", value);
            }
        }
    }

    public static void validate(ASTcfscriptStatement node, CFMLSecurityAnalyzerValidator validator) {
        Token startToken = node.getStartToken();
        String value = startToken.image;
        if (null != value && value.toLowerCase().startsWith("cookie.")) {
            CookieRule._validate(node, validator, "secure", value);
            CookieRule._validate(node, validator, "httponly", value);
        }
    }

    private static void _validate(ASTcfscriptStatement node, CFMLSecurityAnalyzerValidator validator, String attr, String value) {
        VariableType type = RulesCommon.getVariableTypeFromAppcfcsOrCurrentfile(value + "." + attr, node, node, new ArrayList<VariableType>());
        String var = null;
        String t = "warning";
        if ("httponly".equals(attr)) {
            t = "error";
        }
        if (RulesCommon.isFunctionType(type)) {
            t = "warning";
        }
        if (type != null && type.getType().equals("constant")) {
            var = type.getValue();
        } else {
            validator.collectValidationResult("cookiesvalidations", attr + " " + RB.getString(RulesCommon.class, "AttribNotGiven"), null, t, node);
            validator.collectInvalidValidationResult("cookiesvalidations", false, node);
        }
        if (null != var && !Cast._boolean(var)) {
            Node inode = node.getNamedAttribute("RVAL");
            boolean nodeFound = false;
            if (inode instanceof ASTStructInitializer) {
                try {
                    Set keyset = ((ASTStructInitializer)inode).getInitializers().keySet();
                    for (Object o : keyset) {
                        if (!(o instanceof Token) || !((Token)o).image.equalsIgnoreCase(attr)) continue;
                        nodeFound = true;
                        validator.collectValidationResult("cookiesvalidations", attr + " " + RB.getString(RulesCommon.class, "AttribFalse"), null, t, (Node)((ASTStructInitializer)inode).getInitializers().get(o));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!nodeFound) {
                validator.collectValidationResult("cookiesvalidations", attr + " " + RB.getString(RulesCommon.class, "AttribFalse"), null, t, node);
            }
        }
    }
}

