/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.util.List;
import java.util.Vector;

public class GetvspostRule {
    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName();
        if ("cfform".equalsIgnoreCase(tagname)) {
            Node httponlyattr = node.getNamedAttribute("method");
            if (null == httponlyattr) {
                return;
            }
            Vector tokens = ((ASTliteral)httponlyattr).tokens;
            String var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) {
                    VariableType nodetype = RulesCommon.getVariableReferenceTypeFromNode(t);
                    if (nodetype.getType().equals("constant")) {
                        var = nodetype.getValue();
                    } else {
                        validator.collectValidationResult("getvspost", RB.getString(GetvspostRule.class, "AttribNotDetermined"), null, "warning", node);
                        validator.collectInvalidValidationResult("getvspost", false, node);
                    }
                }
                if (t instanceof String) {
                    var = (String)t;
                }
                if (null == var) continue;
                if (var.equalsIgnoreCase("get")) {
                    validator.collectValidationResult("getvspost", RB.getString(GetvspostRule.class, "AttribVal.Get"), null, "warning", node);
                    validator.collectInvalidValidationResult("getvspost", false, node);
                    continue;
                }
                validator.collectInvalidValidationResult("getvspost", true, node);
            }
        }
    }

    public static void validate(ASTpcdata node, CFMLSecurityAnalyzerValidator validator) {
        String bb;
        boolean vulnerable;
        List<Node> siblings = node.jjtGetParent().getDirectChildren();
        String b = node.buffer.toString().toLowerCase().trim().toLowerCase();
        if (b.contains("<form")) {
            vulnerable = false;
            for (Node sibling : siblings) {
                if (!(sibling instanceof ASTpcdata) || !(bb = ((ASTpcdata)sibling).buffer.toString().toLowerCase().trim()).contains("\"get\"") && !bb.contains("'get'")) continue;
                vulnerable = true;
                break;
            }
            if (vulnerable) {
                validator.collectValidationResult("getvspost", RB.getString(GetvspostRule.class, "AttribVal.Get"), null, "warning", node, false);
            }
        }
        if (b.contains("<form")) {
            vulnerable = true;
            for (Node sibling : siblings) {
                if (!(sibling instanceof ASTpcdata) || !(bb = ((ASTpcdata)sibling).buffer.toString().toLowerCase().trim()).contains("method")) continue;
                vulnerable = false;
                break;
            }
            if (vulnerable) {
                validator.collectValidationResult("getvspost", RB.getString(GetvspostRule.class, "DefaultAttrib.Get"), null, "warning", node, false);
            }
        }
    }
}

