/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.runtime.Cast;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.util.Vector;

public class LocationRule {
    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName();
        if ("cflocation".equalsIgnoreCase(tagname)) {
            LocationRule.checkLocationAttribute(node, validator, "addtoken");
        }
    }

    private static void checkLocationAttribute(TagNode node, CFMLSecurityAnalyzerValidator validator, String attribute) {
        Node httponlyattr = node.getNamedAttribute(attribute);
        if (null == httponlyattr) {
            validator.collectValidationResult("cflocationvalidations", attribute + " " + RB.getString(LocationRule.class, "NotSpecified.DefaultAddToken"), null, "warning", node);
            validator.collectInvalidValidationResult("cflocationvalidations", false, node);
        } else {
            Vector tokens = ((ASTliteral)httponlyattr).tokens;
            String var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                VariableType nodetype = null;
                if (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) {
                    nodetype = RulesCommon.getVariableReferenceTypeFromNode(t);
                    if (nodetype.getType().equals("constant")) {
                        var = nodetype.getValue();
                    } else {
                        validator.collectValidationResult("cflocationvalidations", attribute + " " + RB.getString(LocationRule.class, "NotDetermined.DefaultAddToken"), nodetype, "warning", httponlyattr);
                        validator.collectInvalidValidationResult("cflocationvalidations", false, httponlyattr);
                    }
                }
                if (t instanceof String) {
                    var = (String)t;
                }
                if (null == var) continue;
                if (Cast._boolean(var)) {
                    validator.collectValidationResult("cflocationvalidations", attribute + " " + RB.getString(LocationRule.class, "AttribTrue"), nodetype, "error", httponlyattr);
                    validator.collectInvalidValidationResult("cflocationvalidations", false, httponlyattr);
                    continue;
                }
                validator.collectInvalidValidationResult("cflocationvalidations", true, httponlyattr);
            }
        }
    }
}

