/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerConstants;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class PasswordRule {
    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        Node n;
        Enumeration attrs = node.getAttrNames();
        boolean flaw = false;
        if (node.getTagName().equals("cfsharepoint") && null != (n = node.getNamedAttribute("login"))) {
            Vector tokens = ((ASTliteral)n).tokens;
            Object var = null;
            boolean sharepointflaw = false;
            boolean passwordnext = false;
            for (int i = 0; i < tokens.size(); ++i) {
                int index2;
                VariableType nodetype;
                Object t = tokens.get(i);
                if (passwordnext && (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) && (nodetype = RulesCommon.getVariableReferenceTypeFromNode(t)).getType().equals("constant")) {
                    sharepointflaw = true;
                }
                if (t instanceof String && (index2 = ((String)t).indexOf("password")) > -1 && index2 < ((String)t).length() - 10) {
                    sharepointflaw = true;
                    break;
                }
                if (!(t instanceof String) || !((String)t).endsWith("password=") && !((String)t).endsWith("password='") && !((String)t).endsWith("password=\"")) continue;
                passwordnext = true;
            }
            if (sharepointflaw) {
                validator.collectValidationResult("passwords", SecurityAnalyzerConstants.PASSWORDMESSAGE, null, "error", n);
            }
        }
        while (attrs.hasMoreElements()) {
            flaw = false;
            String attrname = (String)attrs.nextElement();
            if (!attrname.toLowerCase().contains("password")) continue;
            Node passwordnode = node.getNamedAttribute(attrname);
            Vector tokens = ((ASTliteral)passwordnode).tokens;
            Object var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) {
                    VariableType nodetype = RulesCommon.getVariableReferenceTypeFromNode(t);
                    if (!nodetype.getType().equals("constant")) continue;
                    flaw = true;
                    continue;
                }
                if (!(t instanceof String)) continue;
                flaw = true;
            }
            if (flaw) {
                validator.collectValidationResult("passwords", SecurityAnalyzerConstants.PASSWORDMESSAGE, null, "error", passwordnode);
                validator.collectInvalidValidationResult("passwords", false, passwordnode);
                continue;
            }
            validator.collectInvalidValidationResult("passwords", true, passwordnode);
        }
    }

    public static void validate(ASTfuncparams node, CFMLSecurityAnalyzerValidator validator) {
        String functionname = node.getFunctionName().toLowerCase();
        if ("setpassword".equals(functionname)) {
            VariableType nodetype = RulesCommon.getVariableReferenceTypeFromNode(node.getDirectChildren().get(0));
            if (nodetype != null && nodetype.getType().equals("constant")) {
                validator.collectValidationResult("passwords", SecurityAnalyzerConstants.PASSWORDMESSAGE, null, "error", node);
            }
            return;
        }
        if (!"encrypt".contains(functionname)) {
            return;
        }
        List<Node> childs = node.getAllChildren();
        if (childs.size() < 3) {
            validator.collectValidationResult("passwords", RB.getString(PasswordRule.class, "EncryptNotGiven"), null, "error", node);
            return;
        }
        Node value = childs.get(2);
        if (value instanceof ASTsimpleVariableReference || value instanceof ASTstructureReference) {
            String nodename = RulesCommon.getVariableReferenceNameFromNode(value);
            VariableType nodetype = RulesCommon.getVariableReferenceType(nodename, node);
            if (RulesCommon.isVulnerableType(nodetype)) {
                validator.collectValidationResult("passwords", RB.getString(PasswordRule.class, "EncryptNotDetermined"), null, "error", node);
            }
            if (RulesCommon.isConstantType(nodetype) && nodetype.getValue().equalsIgnoreCase("CFMX_COMPAT")) {
                validator.collectValidationResult("passwords", RB.getString(PasswordRule.class, "CfmxCompatUsed"), null, "error", node);
            }
        } else if (value instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)value).tokens;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (!(t instanceof String) || !((String)t).equalsIgnoreCase("CFMX_COMPAT")) continue;
                validator.collectValidationResult("passwords", RB.getString(PasswordRule.class, "CfmxCompatUsed"), null, "error", node);
            }
        } else if (value instanceof ASTruntimeCall) {
            validator.collectValidationResult("passwords", RB.getString(PasswordRule.class, "AvoidCfmxCompat"), null, "warning", node);
        }
    }

    public static void validate(ASTcfscriptStatement node, CFMLSecurityAnalyzerValidator validator) {
        String value = ((ASTruntimeCall)node.getNamedAttribute("RVAL")).getFunctionName();
        if (!value.equals("_createobject")) {
            return;
        }
        Node runtimenode = node.getNamedAttribute("RVAL");
        if (runtimenode == null || !(runtimenode instanceof ASTruntimeCall)) {
            return;
        }
        ExprNode literal = ((ASTruntimeCall)runtimenode).getNewArgumentCfc();
        if (null == literal) {
            return;
        }
        Vector tokens = ((ASTliteral)literal).tokens;
        Object t = tokens.get(0);
        String argkey = "";
        if (t instanceof String) {
            String cfc = (String)t;
            if ((cfc = cfc.toLowerCase()).equals("http") || cfc.equals("query") || cfc.equals("ftp")) {
                argkey = "password";
            } else {
                return;
            }
        }
        List<Node> arguments = ((ASTruntimeCall)runtimenode).getParameters().getDirectChildren();
        for (Node inode : arguments) {
            VariableType nodetype;
            ASTtagAttribute attr;
            Node argnode;
            if (!(inode instanceof ASTtagAttribute) || (argnode = (attr = (ASTtagAttribute)inode).getNamedAttribute(argkey)) == null || (nodetype = RulesCommon.getVariableReferenceTypeFromNode(argnode)) == null || !nodetype.getType().equals("constant")) continue;
            validator.collectValidationResult("passwords", SecurityAnalyzerConstants.PASSWORDMESSAGE, null, "error", node);
            break;
        }
    }
}

