/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerServlet;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import java.util.ArrayList;
import java.util.List;

public class UnnamedappRule {
    public static boolean validate(Node root) {
        String value;
        ArrayList<VariableType> variableTypes = new ArrayList<VariableType>();
        RulesCommon.getVariableReferenceTypeFromCfscriptstatement(root, "this.name", root, variableTypes);
        boolean flaw = true;
        VariableType type = null;
        if (variableTypes.size() > 0) {
            type = variableTypes.get(variableTypes.size() - 1);
        }
        if (null != type && null != type.getType() && (RulesCommon.isConstantType(type) || RulesCommon.isFunctionType(type)) && (value = type.getValue()).trim().length() > 0) {
            flaw = false;
        }
        if (flaw) {
            List<Node> childs = root.getDirectChildren();
            flaw = UnnamedappRule._validate(childs);
        }
        return flaw;
    }

    private static boolean _validate(List<Node> childs) {
        boolean flaw = true;
        for (Node node : childs) {
            Node varnode;
            String tagname;
            if (node instanceof ASTcftag && (tagname = ((ASTcftag)node).getTagName()).equalsIgnoreCase("cfapplication") && (varnode = node.getNamedAttribute("name")) != null) {
                flaw = false;
                break;
            }
            flaw = UnnamedappRule._validate(node.getAllChildren());
            if (flaw) continue;
            break;
        }
        return flaw;
    }

    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        try {
            Node varnode;
            String tagname = ((ASTcftag)node).getTagName();
            if (tagname.equalsIgnoreCase("cfapplication") && (varnode = node.getNamedAttribute("name")) != null) {
                validator.removeValidationResultForKey("unnamedapp");
                SecurityAnalyzerServlet.isUnnamed = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void validate(ASTcfscriptStatement node, CFMLSecurityAnalyzerValidator validator) {
        if (!SecurityAnalyzerServlet.isUnnamed) {
            return;
        }
        try {
            boolean flaw = UnnamedappRule.validate(node);
            if (!flaw) {
                validator.removeValidationResultForKey("unnamedapp");
                SecurityAnalyzerServlet.isUnnamed = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

