/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.server.ConfigListListener;
import coldfusion.server.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class ConfigList
extends ArrayList {
    private String name;
    private String itemLabel;
    private String[] formats;
    private ConfigListListener listener;

    public synchronized void init(Service service, String name, String itemLabel) {
        this.name = name;
        this.itemLabel = itemLabel;
        this.formats = this.tokenize((String)service.getResourceBundle().get(name + ".formats"));
    }

    private void setChanged() {
        if (this.listener != null) {
            this.listener.listModified(this);
        }
    }

    public void setListener(ConfigListListener listener) {
        this.listener = listener;
    }

    @Override
    public synchronized String toString() {
        StringBuffer out = new StringBuffer();
        out.append("<" + this.name + ">\n");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.itemLabel == null || this.itemLabel.length() == 0) {
                out.append(this.get(i));
                continue;
            }
            out.append("\t<" + this.itemLabel + ">" + this.get(i) + "</" + this.itemLabel + ">\n");
        }
        out.append("</" + this.name + ">\n");
        return out.toString();
    }

    private String getFormatter(Object item) {
        return null;
    }

    private String[] tokenize(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(str, ",");
        String[] array = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            array[i] = t.nextToken();
            ++i;
        }
        return array;
    }

    @Override
    public synchronized boolean add(Object item) {
        super.add(item);
        this.setChanged();
        return true;
    }

    @Override
    public synchronized void add(int i, Object item) {
        Object old = super.get(i);
        if (!item.equals(old)) {
            super.add(i, item);
            this.setChanged();
        }
    }

    @Override
    public synchronized Object set(int i, Object item) {
        Object old = super.set(i, item);
        if (!old.equals(item)) {
            this.setChanged();
        }
        return old;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.setChanged();
    }

    @Override
    public synchronized boolean addAll(Collection t) {
        super.addAll(t);
        this.setChanged();
        return true;
    }

    @Override
    public synchronized Object remove(int index) {
        Object value = super.remove(index);
        if (value != null) {
            this.setChanged();
        }
        return value;
    }
}

