/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.runtime.Cast;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.runtime.locale.CFLocaleMgrException;
import coldfusion.server.Formatter;
import coldfusion.server.Service;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumberFormatter
implements Formatter {
    @Override
    public Object format(Object value, Service service, String name) {
        return Cast._cast(value, Number.class);
    }

    public static String format(Object value, Locale locale) {
        double number = NumberFormatter.formattableDouble(value);
        DecimalFormatSymbols sym = new DecimalFormatSymbols(locale);
        char MINUS_SIGN = sym.getMinusSign();
        int ECHAR = 69;
        int COMMA = 44;
        int DECIMAL = 46;
        int NINE = 57;
        StringBuffer newMask = new StringBuffer("");
        long newnum = Math.round(number);
        String mask = String.valueOf(newnum);
        int maskLength = mask.length();
        if (maskLength > String.valueOf(number).lastIndexOf(".")) {
            maskLength = mask.length() - 1;
        }
        if (mask.toUpperCase().lastIndexOf(69) < 0) {
            for (int i = 0; i < maskLength; ++i) {
                if (mask.charAt(i) != ',' && mask.charAt(i) != '.' && mask.charAt(i) != MINUS_SIGN) {
                    newMask = newMask.append('9');
                    continue;
                }
                if (mask.charAt(i) == '.') break;
                newMask = newMask.append(mask.charAt(i));
            }
        }
        newMask = newMask.append(',');
        CFLocale cflocale = CFLocaleMgr.getMgr().getCFLocale(locale);
        try {
            return cflocale.FormatNumber(number, newMask.toString()).trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String format(Object value) {
        double number = NumberFormatter.formattableDouble(value);
        StringBuffer newMask = new StringBuffer("");
        int COMMA = 44;
        int DECIMAL = 46;
        int NINE = 57;
        int ECHAR = 69;
        int MINUS_SIGN = 45;
        long newnum = Math.round(number);
        String mask = String.valueOf(newnum);
        int maskLength = mask.length();
        if (maskLength > String.valueOf(number).lastIndexOf(".")) {
            maskLength = mask.length() - 1;
        }
        if (mask.toUpperCase().lastIndexOf(69) < 0) {
            for (int i = 0; i < maskLength; ++i) {
                if (mask.charAt(i) != ',' && mask.charAt(i) != '.' && mask.charAt(i) != '-') {
                    newMask = newMask.append('9');
                    continue;
                }
                if (mask.charAt(i) == '.') break;
                newMask = newMask.append(mask.charAt(i));
            }
        }
        newMask = newMask.append(',');
        return NumberFormatter.format(number, newMask.toString()).trim();
    }

    public static String format(double number, String mask) {
        try {
            CFLocale cflocale = CFLocaleMgr.getMgr().getDefaultCFLocale();
            return cflocale.FormatNumber(number, mask);
        }
        catch (CFLocaleMgrException e) {
            return "";
        }
    }

    private static double formattableDouble(Object value) {
        if (Cast._String(value).length() == 0) {
            return 0.0;
        }
        return Cast._double(value);
    }

    public static boolean isNumeric(Object NumberAsString, String locale_string) {
        boolean rc;
        if (NumberAsString instanceof Integer || NumberAsString instanceof Double) {
            rc = true;
        } else if (!(NumberAsString instanceof String)) {
            rc = false;
        } else {
            CFLocale cflocale = CFLocaleMgr.getMgr().getCFLocale(locale_string);
            try {
                cflocale.ParseNumber((String)NumberAsString);
                rc = true;
            }
            catch (Exception e) {
                rc = false;
            }
        }
        return rc;
    }
}

