/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.centralconfig.client.CentralConfigRefreshServlet;
import coldfusion.log.Logger;
import coldfusion.runtime.NeoException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.LoggingService;
import coldfusion.server.ParsingConfigFileException;
import coldfusion.server.Service;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceListener;
import coldfusion.server.ServiceMetaData;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.WatchService;
import coldfusion.server.WritingConfigFileException;
import coldfusion.serverless.InMemoryFile;
import coldfusion.serverless.InMemoryOutputStream;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.FileLock;
import coldfusion.util.IOUtils;
import coldfusion.watch.Watcher;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxDeserializer;
import coldfusion.wddx.WddxSerializer;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ServiceBase
implements Service,
ConfigMapListener,
Watcher.Listener {
    private Logger logger;
    protected Map rb;
    private long lastmodified;
    private boolean enableWatch;
    private List watchFileList;
    protected List serviceListners;
    protected int startCount = 0;
    protected boolean backup = true;
    public static int serverId = new Random().nextInt(100000000);

    protected boolean isFirstLoad() {
        return this.startCount == 1;
    }

    protected void setBackup(boolean backup) {
        this.backup = backup;
    }

    @Override
    public void start() throws ServiceException {
        ++this.startCount;
        if (this.isFirstLoad()) {
            try {
                LoggingService service = ServiceFactory.getLoggingService();
                this.logger = service.getLogger(this.getLoggerName());
            }
            catch (Throwable t) {
                this.logger = null;
            }
        }
        this.load();
        if (this.isFirstLoad()) {
            this.registerWithWatchService();
        } else {
            this.mapModified(false);
        }
    }

    @Override
    public void stop() throws ServiceException {
        this.unregisterWithWatchService();
    }

    @Override
    public void restart() throws ServiceException {
        this.stop();
        this.start();
    }

    @Override
    public int getStatus() {
        return 4;
    }

    public void load() throws ServiceException {
    }

    public void store() throws ServiceException {
    }

    public void store(boolean broadcast) throws ServiceException {
    }

    public void store(Object key, Object value, Object oldValue) throws ServiceException {
    }

    public void store(Object key, Object value, Object oldValue, boolean broadCast) throws ServiceException {
    }

    public final Object deserialize(File path) {
        return this.deserialize(path, false);
    }

    public final Object deserialize(final File path, final boolean local) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServiceBase.this.doDeserialize(path, local);
            }
        });
    }

    private synchronized Object doDeserialize(File file, boolean local) {
        if (ServerlessUtil.isLambdaEnv()) {
            file = this.createInMemoryFile(file);
        }
        boolean doLock = this.checkLock();
        FileLock lock = new FileLock(file.getParent(), file.getName());
        boolean inMemoryFile = file instanceof InMemoryFile;
        try {
            InputSource source;
            WddxDeserializer deserializer;
            block19: {
                if (doLock) {
                    lock.obtain();
                }
                deserializer = new WddxDeserializer();
                source = inMemoryFile ? new InputSource(new ByteArrayInputStream(((InMemoryFile)file).read())) : new InputSource(new FileReader(file));
                try {
                    if (!local) {
                        source = CentralConfigClientUtil.pullFromCCS(file, source);
                    }
                }
                catch (Throwable t) {
                    if (this.logger == null) break block19;
                    this.logger.error(t);
                }
            }
            Object t = deserializer.deserialize(source);
            return t;
        }
        catch (Exception ex) {
            Object name = file.getName();
            if (((String)name).startsWith("neo-")) {
                int index;
                File path = file.getParentFile();
                File backup = new File(path, (String)(name = ((String)name).substring(0, index = ((String)name).lastIndexOf(".xml")) + ".bak"));
                if (backup.exists() && backup.length() > 0L) {
                    if (!inMemoryFile) {
                        file.delete();
                    }
                    backup.renameTo(file);
                    if (this.logger != null) {
                        this.logger.error(ex);
                    } else {
                        ex.printStackTrace();
                    }
                    try {
                        WddxDeserializer deserializer = new WddxDeserializer();
                        InputSource source = new InputSource(new FileReader(file));
                        Object object = deserializer.deserialize(source);
                        return object;
                    }
                    catch (Exception e) {
                        throw new ParsingConfigFileException(file.getAbsolutePath(), e);
                    }
                }
                throw new ParsingConfigFileException(file.getAbsolutePath(), ex);
            }
            throw new ParsingConfigFileException(file.getAbsolutePath(), ex);
        }
        finally {
            if (doLock) {
                lock.release();
            }
        }
    }

    private boolean checkLock() {
        try {
            WatchService ws = ServiceFactory.getWatchService();
            if (null == ws) {
                return false;
            }
            return this.enableWatch && ws.isWatchEnabled();
        }
        catch (ServiceFactory.ServiceNotAvailableException e) {
            return false;
        }
    }

    public final String serialize(Object obj) {
        try {
            WddxSerializer ws = new WddxSerializer();
            StringWriter sw = new StringWriter();
            ws.serialize(obj, sw);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public final void serialize(final Object obj, final File file, final boolean broadcast) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServiceBase.this.doSerialize(obj, file, broadcast);
                return null;
            }
        });
    }

    public final void serialize(final Object obj, final File file, final boolean broadcast, final Object key, final Object value, final Object oldValue) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServiceBase.this.doSerialize(obj, file, broadcast, key, value, oldValue);
                return null;
            }
        });
    }

    public final void serialize(final Object obj, final File file) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServiceBase.this.doSerialize(obj, file);
                return null;
            }
        });
    }

    private void doSerialize(Object obj, File file) {
        this.doSerialize(obj, file, true);
    }

    private void doSerialize(Object obj, File file, boolean broadcast) {
        this.doSerialize(obj, file, broadcast, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSerialize(Object obj, File file, boolean broadcast, Object key, Object value, Object oldValue) {
        boolean isMemoryFile;
        if (ServerlessUtil.isLambdaEnv()) {
            file = this.createInMemoryFile(file);
        }
        if (!(isMemoryFile = file instanceof InMemoryFile)) {
            if (broadcast) {
                if (CentralConfigClientUtil.isCCSEnbledButNotRunning()) {
                    CentralConfigRefreshServlet.reloadAllModules();
                    throw new CCSEnabledButNotAvailableException();
                }
                String downnodes = CentralConfigClientUtil.isAnyNodeDown();
                if (downnodes.length() > 0) {
                    CentralConfigRefreshServlet.reloadAllModules();
                    throw new CCSNodesDownException(downnodes);
                }
            }
            FileWriter fwriter = null;
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ex) {
                throw new ServiceRuntimeException(ex);
            }
            File path = file.getParentFile();
            String name = file.getName();
            boolean doLock = this.checkLock();
            FileLock lock = new FileLock(file.getParent(), name);
            if (ServiceFactory.isFiddleServiceEnabled() && name.equals("neo-security.xml")) {
                return;
            }
            try {
                if (doLock) {
                    lock.obtain();
                }
                int index = name.lastIndexOf(".xml");
                String backupfilename = name.substring(0, index) + ".bak";
                File backup = new File(path, backupfilename);
                if (file.length() > 0L && this.backup) {
                    IOUtils.copyFile(file, backup);
                }
                BufferedWriter out = null;
                try {
                    fwriter = new FileWriter(file, false);
                    CentralConfigClientUtil.modifyFileMetadata(file);
                    out = new BufferedWriter(fwriter);
                    String data = this.serialize(obj);
                    if (data == null || data.length() == 0) {
                        throw new WritingConfigFileException(file.getAbsolutePath());
                    }
                    out.write(data);
                    out.flush();
                    if (!broadcast) return;
                    CentralConfigClientUtil.pushToCCS(file, data, key, value, oldValue);
                    return;
                }
                catch (Throwable ex) {
                    if (backup.length() > 0L && this.backup) {
                        IOUtils.copyFile(backup, file);
                    }
                    this.lastmodified = backup.lastModified();
                    throw new ServiceRuntimeException(ex);
                }
                finally {
                    if (out != null) {
                        out.close();
                        this.lastmodified = file.lastModified();
                        CentralConfigClientUtil.modifyFileMetadata(file);
                    }
                    if (fwriter != null) {
                        fwriter.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
            finally {
                if (doLock) {
                    lock.release();
                }
            }
        }
        String data = this.serialize(obj);
        InMemoryOutputStream os = new InMemoryOutputStream((InMemoryFile)file);
        try {
            ((OutputStream)os).write(data.getBytes());
            os.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InMemoryFile createInMemoryFile(File f) {
        InMemoryFile mFile = null;
        try {
            mFile = new InMemoryFile(f.getAbsolutePath(), f);
            FileInputStream is = new FileInputStream(f);
            byte[] src = new byte[is.available()];
            is.read(src);
            InMemoryOutputStream os = new InMemoryOutputStream(mFile);
            os.write(src);
            os.close();
        }
        catch (Exception exception) {}
        finally {
            return mFile;
        }
    }

    protected String getLoggerName() {
        return "coldfusion.server";
    }

    protected final boolean info(String s) {
        if (this.logger != null) {
            this.logger.info(s);
        } else {
            System.out.println(s);
        }
        return true;
    }

    public Object deserialize(InputStream is) throws WddxDeserializationException, ParserConfigurationException, SAXException, IOException {
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = new InputSource(is);
        return deserializer.deserialize(source);
    }

    protected final boolean warning(String s) {
        if (this.logger != null) {
            this.logger.warn(s);
        } else {
            System.out.println(s);
        }
        return true;
    }

    protected final boolean debug(String s) {
        if (this.logger != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(s);
            }
        } else {
            System.out.println(s);
        }
        return true;
    }

    @Override
    public void mapModified() {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(boolean broadcast) {
        try {
            this.store(broadcast);
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key) {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value) {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value, Object oldValue) {
        try {
            this.store(key, value, oldValue);
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value, Object oldValue, boolean broadcast) {
        try {
            this.store(key, value, oldValue, broadcast);
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    protected void initMap(ConfigMap map, String str) {
        for (ConfigMap m : map.values()) {
            m.init(this, str);
        }
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
        }
        return this.rb;
    }

    @Override
    public ServiceMetaData getMetaData() {
        return new ServiceBaseMetaData();
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    public void setEnableWatch(boolean enableWatch) {
        this.enableWatch = enableWatch;
    }

    public void setWatchFile(File file) {
        if (this.watchFileList == null) {
            this.watchFileList = new ArrayList();
        }
        if (!ServerlessUtil.isLambdaEnv()) {
            this.watchFileList.add(file);
        }
    }

    @Override
    public void filesModified(List l) {
        for (File modifiedFile : l) {
            if (modifiedFile.lastModified() <= this.getLastModified()) continue;
            if (this.logger != null) {
                this.logger.info(modifiedFile.getName() + "  has been modified . Reloading the service " + this);
            }
            try {
                this.load();
            }
            catch (ServiceException e) {
                if (this.logger == null) continue;
                this.logger.error(e);
            }
        }
    }

    @Override
    public boolean isInterested(File modifiedFile) {
        boolean condition = false;
        Iterator itr = this.watchFileList.iterator();
        while (itr.hasNext() && !(condition = modifiedFile.getName().equalsIgnoreCase(((File)itr.next()).getName()))) {
        }
        return condition;
    }

    public void registerWithWatchService() {
        block3: {
            try {
                if (this.enableWatch) {
                    WatchService watchServicce = ServiceFactory.getWatchService();
                    watchServicce.addListener(this);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block3;
                this.logger.error(e);
            }
        }
    }

    public void unregisterWithWatchService() {
        block3: {
            try {
                if (this.enableWatch) {
                    WatchService watchService = ServiceFactory.getWatchService();
                    watchService.removeListener(this);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block3;
                this.logger.error(e);
            }
        }
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        if (this.serviceListners == null) {
            this.serviceListners = new ArrayList();
        }
        this.serviceListners.add(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        if (this.serviceListners != null) {
            this.serviceListners.remove(listener);
        }
    }

    protected void notifyServiceListeners() {
        if (this.serviceListners == null) {
            return;
        }
        for (int i = 0; i < this.serviceListners.size(); ++i) {
            ServiceListener listener = (ServiceListener)this.serviceListners.get(i);
            listener.serviceModified();
        }
    }

    public static class CCSEnabledButNotAvailableException
    extends NeoException {
    }

    public static class CCSNodesDownException
    extends NeoException {
        public String downnodes;

        public CCSNodesDownException(String dn) {
            this.downnodes = dn;
        }
    }

    public class ServiceBaseMetaData
    implements ServiceMetaData {
        @Override
        public int getPropertyCount() {
            return 0;
        }

        @Override
        public String getPropertyLabel(int index) {
            return null;
        }

        @Override
        public String getPropertyType(int index) {
            return null;
        }

        @Override
        public boolean exists(String name) {
            return false;
        }
    }
}

