/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.runtime.ApplicationException;
import coldfusion.vfs.VFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;

public abstract class StoreService {
    private static Map<String, StoreService> services = new HashMap<String, StoreService>();

    public static void register(String scheme, StoreService storeService) {
        if (storeService != null) {
            services.put(scheme.toLowerCase(), storeService);
        }
    }

    public static StoreService getStoreService(String scheme) {
        StoreService storeService = services.get(scheme.toLowerCase());
        if (storeService == null) {
            throw new StoreServiceNotFoundException(scheme);
        }
        return storeService;
    }

    public static Object getAccessControlList(String url) {
        RequestMonitorEventProcessor.onFunctionStart("getAccessControlList");
        try {
            VFile vfile = new VFile(url);
            String scheme = vfile.getFileObject().getName().getScheme();
            StoreService storeService = StoreService.getStoreService(scheme);
            Object object = storeService.getAccessControlList(url, vfile);
            return object;
        }
        catch (Exception e) {
            throw new StoreOperationException(e);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd("getAccessControlList");
        }
    }

    public static void setMetadata(String url, Map metadata) {
        RequestMonitorEventProcessor.onFunctionStart("setMetadata");
        try {
            VFile vfile = new VFile(url);
            String scheme = vfile.getFileObject().getName().getScheme();
            StoreService storeService = StoreService.getStoreService(scheme);
            storeService.setMetadata(url, vfile, metadata);
        }
        catch (FileSystemException e) {
            throw new StoreOperationException(e);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd("setMetadata");
        }
    }

    public static Map getMetadata(String url) {
        RequestMonitorEventProcessor.onFunctionStart("getMetadata");
        try {
            VFile vfile = new VFile(url);
            String scheme = vfile.getFileObject().getName().getScheme();
            StoreService storeService = StoreService.getStoreService(scheme);
            Map map = storeService.getMetadata(url, vfile);
            return map;
        }
        catch (FileSystemException e) {
            throw new StoreOperationException(e);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd("getMetadata");
        }
    }

    public abstract Object getAccessControlList(String var1, VFile var2);

    public abstract void setMetadata(String var1, VFile var2, Map var3);

    public abstract Map getMetadata(String var1, VFile var2);

    public abstract boolean isInstanceOfS3FileObject(Object var1);

    public abstract void copyFile(File var1, VFile var2) throws IOException;

    public abstract String[] doListChildren(Object var1) throws Exception;

    public abstract void setFileSystemOptions(FileSystemOptions var1, String var2, String var3, String var4, boolean var5);

    public abstract void setUploaderMaxSize(Object var1);

    public abstract void createBucket(VFile var1, String var2, Object var3);

    public abstract boolean isSchemeSupported(String var1);

    public abstract StandardFileSystemManager getFileSystemManager(String var1);

    public static class StoreServiceNotFoundException
    extends ApplicationException {
        public String scheme;

        public StoreServiceNotFoundException(String scheme) {
            this.scheme = scheme;
        }
    }

    public static class StoreOperationException
    extends ApplicationException {
        public StoreOperationException() {
        }

        public StoreOperationException(Throwable e) {
            super(e);
        }
    }
}

