/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.Cast;
import coldfusion.runtime.StringFunc;
import coldfusion.server.Formatter;
import coldfusion.server.Service;
import coldfusion.wddx.RecordSet;
import coldfusion.wddx.SpecialCharInfo;
import coldfusion.wddx.UTF8Converter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StringFormatter
implements Formatter {
    static Set<String> htmlEscapeList = new HashSet<String>();
    static Set<String> htmlNoColonEscapeList = new HashSet<String>();
    private static int LONGEST_HTML_ESCAPE_ENTITY = 6;
    private static final int SMALLEST_HTML_ESCAPE_ENTITY = 2;

    @Override
    public Object format(Object value, Service service, String name) {
        return Cast._cast(value, String.class);
    }

    public static String paragraphFormat(String string) {
        StringBuffer out = new StringBuffer(string.length());
        int count = string.length();
        boolean newline = false;
        block4: for (int i = 0; i < count; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < count && string.charAt(i + 1) == '\r') {
                        newline = false;
                    }
                    out.append(' ');
                    continue block4;
                }
                case '\n': {
                    if (newline) {
                        out.append(" <P>\r\n");
                        newline = false;
                        continue block4;
                    }
                    out.append(' ');
                    newline = true;
                    continue block4;
                }
                default: {
                    out.append(c);
                    newline = false;
                }
            }
        }
        out.append(" <P>");
        return out.toString();
    }

    public static void escapeXML(String in, StringBuffer out, boolean xml) {
        StringFormatter.escapeXML(in, out, xml, false);
    }

    public static void escapeXML(String in, StringBuffer out, boolean xml, boolean escapeNewSet) {
        int length = in.length();
        SpecialCharInfo[] chars = null;
        if (xml) {
            chars = UTF8Converter.getAttrCharInfo();
        }
        block8: for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block8;
                }
                case '>': {
                    out.append("&gt;");
                    continue block8;
                }
                case '&': {
                    if (escapeNewSet && !xml) {
                        int indexColon = in.indexOf(";", i);
                        if (indexColon != -1) {
                            if (htmlEscapeList.contains(in.substring(i + 1, indexColon))) {
                                out.append("&");
                                continue block8;
                            }
                            if (in.length() > i + 2 && in.charAt(i + 1) == '#' && StringFormatter.isEntityNumeral(in, indexColon, i)) {
                                out.append("&");
                                continue block8;
                            }
                        }
                        if (StringFormatter.isNamedEntityNoColon(in, i, length)) {
                            out.append("&");
                            continue block8;
                        }
                    }
                    out.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    out.append(xml ? "&apos;" : "'");
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                default: {
                    if (xml && c > '\u009f' && c < '\u0100') {
                        out.append(chars[c].encoding);
                        continue block8;
                    }
                    if (escapeNewSet && (c > '\u0000' && c < '\t' || c == '\u000b' || c == '\f' || c > '\r' && c < ' ' || c > '~' && c < '\u0085' || c > '\u0085' && c < '\u00a0' || c > '\ufdcf' && c < '\ufde0' || c > '\ufffd' && c < '\u10000' || c > '\u1fffd' && c < '\u20000' || c > '\u2fffd' && c < '\u30000' || c > '\u3fffd' && c < '\u40000' || c > '\u4fffd' && c < '\u50000' || c > '\u5fffd' && c < '\u60000' || c > '\u6fffd' && c < '\u70000' || c > '\u7fffd' && c < '\u80000' || c > '\u8fffd' && c < '\u90000' || c > '\u9fffd' && c < '\ua0000' || c > '\uafffd' && c < '\ub0000' || c > '\ubfffd' && c < '\uc0000' || c > '\ucfffd' && c < '\ud0000' || c > '\udfffd' && c < '\ue0000' || c > '\uefffd' && c < '\uf0000' || c > '\uffffd' && c < '\u100000' || c > '\u10fffd' && c < '\u110000')) continue block8;
                    out.append(c);
                }
            }
        }
    }

    private static boolean isNamedEntityNoColon(String str, int i, int length) {
        for (int j = 2; j <= LONGEST_HTML_ESCAPE_ENTITY && i + j < length; ++j) {
            if (!htmlNoColonEscapeList.contains(str.substring(i + 1, i + j + 1))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEntityNumeral(String str, int indexColon, int i) {
        String sub = str.substring(i + 2, indexColon);
        int num = -1;
        try {
            num = sub.length() > 1 && sub.substring(0, 1).equalsIgnoreCase("x") ? Integer.parseInt(sub.substring(1), 16) : Integer.parseInt(sub);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Character.isValidCodePoint(num);
    }

    public static void escapeJSString(String in, StringBuffer out) {
        int length = in.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\n': {
                    out.append("\\n");
                    continue block10;
                }
                case '\r': {
                    out.append("\\r");
                    continue block10;
                }
                case '\t': {
                    out.append("\\t");
                    continue block10;
                }
                case '\b': {
                    out.append("\\b");
                    continue block10;
                }
                case '\f': {
                    out.append("\\f");
                    continue block10;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    out.append("\\'");
                    continue block10;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block10;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static String htmlCodeFormat(String html, double version) {
        StringBuffer thisText = new StringBuffer(11 + Math.round((float)html.length() * 1.5f));
        thisText.append("<PRE>");
        StringFormatter.escapeXML(html, thisText, false);
        thisText.append("</PRE>");
        return thisText.toString();
    }

    public static String htmlEditFormat(String html, double version) {
        return StringFormatter.htmlEditFormat(html, version, false);
    }

    public static String htmlEditFormat(String html, double version, boolean escapeNewSet) {
        StringBuffer thisText = new StringBuffer(11 + Math.round((float)html.length() * 1.5f));
        StringFormatter.escapeXML(html, thisText, false, escapeNewSet);
        return thisText.toString();
    }

    public static String xmlFormat(String string) {
        return StringFormatter.xmlFormat(string, false);
    }

    public static String xmlFormat(String string, boolean escapeNewSet) {
        StringBuffer out = new StringBuffer((int)(1.5 * (double)string.length()));
        StringFormatter.escapeXML(string, out, true, escapeNewSet);
        return out.toString();
    }

    public static String jsStringFormat(String string) {
        StringBuffer out = new StringBuffer((int)(1.5 * (double)string.length()));
        StringFormatter.escapeJSString(string, out);
        return out.toString();
    }

    public static String scriptFormat(Object obj, String varName, boolean wddxFormat, boolean ASFormat, Map options) {
        StringBuffer out = new StringBuffer();
        StringFormatter.scriptFormat(obj, varName, wddxFormat, ASFormat, out, options);
        return out.toString();
    }

    private static void scriptFormat(Object obj, String varName, boolean wddxFormat, boolean ASFormat, StringBuffer out, Map options) {
        boolean preserveCase;
        out.append(varName).append(" = ");
        boolean bl = preserveCase = options != null && Cast._boolean(options.get("preserveCaseForStructKey"));
        if (obj instanceof Number || obj instanceof Boolean || obj instanceof CFBoolean) {
            out.append(obj.toString()).append(";\r\n");
        } else if (obj instanceof String || obj instanceof Character) {
            out.append('\"');
            StringFormatter.escapeJSString(obj.toString(), out);
            out.append("\";\r\n");
        } else if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            out.append(" new Date(").append(cal.get(1)).append(", ").append(cal.get(2)).append(", ").append(cal.get(5)).append(", ").append(cal.get(11)).append(", ").append(cal.get(12)).append(", ").append(cal.get(13)).append(");\r\n");
        } else if (obj instanceof Map) {
            Map s = (Map)obj;
            Iterator i = s.entrySet().iterator();
            if (ASFormat) {
                out.append("{};\r\n");
            } else {
                out.append("new Object();\r\n");
            }
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String str = (String)e.getKey();
                Object val = e.getValue();
                str = StringFunc.Replace(str, "\\", "\\\\", "ALL");
                str = StringFunc.Replace(str, "\"", "\\\"", "ALL");
                StringBuffer sb = new StringBuffer().append(varName).append("[\"");
                sb.append(!preserveCase ? str.toLowerCase() : str);
                sb.append("\"]");
                StringFormatter.scriptFormat(val, sb.toString(), wddxFormat, ASFormat, out, options);
            }
        } else if (obj instanceof RecordSet && wddxFormat) {
            out.append("new WddxRecordset();\r\n");
            RecordSet rs = (RecordSet)obj;
            int rowCount = rs.getRowCount();
            int columnCount = rs.getColumnCount();
            String[] columnNames = rs.getColumnNames();
            for (int column = 0; column < columnCount; ++column) {
                String colName = "col" + column;
                if (ASFormat) {
                    out.append(colName).append(" = [];\r\n");
                } else {
                    out.append(colName).append(" = new Array();\r\n");
                }
                for (int row = 0; row < rowCount; ++row) {
                    String newVarName = new StringBuffer().append(colName).append('[').append(row).append(']').toString();
                    StringFormatter.scriptFormat(rs.getField(row + 1, column + 1), newVarName, wddxFormat, ASFormat, out, options);
                }
                out.append(varName).append("[\"").append(columnNames[column].toLowerCase()).append("\"] = ").append(colName).append(";\r\n");
                out.append(colName).append(" = null;\r\n");
            }
        } else if (obj instanceof RecordSet && !wddxFormat) {
            if (ASFormat) {
                out.append("[];\r\n");
            } else {
                out.append("new Array();\r\n");
            }
            RecordSet rs = (RecordSet)obj;
            int rowCount = rs.getRowCount();
            int columnCount = rs.getColumnCount();
            String[] columnNames = rs.getColumnNames();
            for (int rows = 0; rows < rowCount; ++rows) {
                if (ASFormat) {
                    out.append(varName).append('[').append(rows).append("] = {};\r\n");
                } else {
                    out.append(varName).append('[').append(rows).append("] = new Object();\r\n");
                }
                for (int column = 0; column < columnCount; ++column) {
                    String newVarName = new StringBuffer().append(varName).append('[').append(rows).append("]['").append(columnNames[column].toLowerCase()).append("']").toString();
                    StringFormatter.scriptFormat(rs.getField(rows + 1, column + 1), newVarName, false, ASFormat, out, options);
                }
            }
        } else if (obj instanceof Collection) {
            if (ASFormat) {
                out.append(" [];\r\n");
            } else {
                out.append(" new Array();\r\n");
            }
            Collection list = (Collection)obj;
            int index = 0;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                StringFormatter.scriptFormat(i.next(), new StringBuffer().append(varName).append('[').append(index).append(']').toString(), wddxFormat, ASFormat, out, options);
                ++index;
            }
        } else if (obj == null) {
            out.append("null;\r\n");
        } else {
            System.out.println(obj.getClass().getName());
        }
    }

    static {
        htmlNoColonEscapeList.add("apos");
        htmlNoColonEscapeList.add("quot");
        htmlNoColonEscapeList.add("amp");
        htmlNoColonEscapeList.add("lt");
        htmlNoColonEscapeList.add("gt");
        htmlNoColonEscapeList.add("nbsp");
        htmlNoColonEscapeList.add("cent");
        htmlNoColonEscapeList.add("pound");
        htmlNoColonEscapeList.add("curren");
        htmlNoColonEscapeList.add("yen");
        htmlNoColonEscapeList.add("brvbar");
        htmlNoColonEscapeList.add("sect");
        htmlNoColonEscapeList.add("uml");
        htmlNoColonEscapeList.add("copy");
        htmlNoColonEscapeList.add("ordf");
        htmlNoColonEscapeList.add("not");
        htmlNoColonEscapeList.add("shy");
        htmlNoColonEscapeList.add("reg");
        htmlNoColonEscapeList.add("macr");
        htmlNoColonEscapeList.add("deg");
        htmlNoColonEscapeList.add("plusmn");
        htmlNoColonEscapeList.add("acute");
        htmlNoColonEscapeList.add("micro");
        htmlNoColonEscapeList.add("para");
        htmlNoColonEscapeList.add("cedil");
        htmlNoColonEscapeList.add("iexcl");
        htmlNoColonEscapeList.add("laquo");
        htmlNoColonEscapeList.add("sup2");
        htmlNoColonEscapeList.add("sup3");
        htmlNoColonEscapeList.add("acute");
        htmlNoColonEscapeList.add("middot");
        htmlNoColonEscapeList.add("sup1");
        htmlNoColonEscapeList.add("ordm");
        htmlNoColonEscapeList.add("raquo");
        htmlNoColonEscapeList.add("frac14");
        htmlNoColonEscapeList.add("frac12");
        htmlNoColonEscapeList.add("frac34");
        htmlNoColonEscapeList.add("iquest");
        htmlNoColonEscapeList.add("Agrave");
        htmlNoColonEscapeList.add("Aacute");
        htmlNoColonEscapeList.add("Acirc");
        htmlNoColonEscapeList.add("Atilde");
        htmlNoColonEscapeList.add("Auml");
        htmlNoColonEscapeList.add("Aring");
        htmlNoColonEscapeList.add("AElig");
        htmlNoColonEscapeList.add("Ccedil");
        htmlNoColonEscapeList.add("Egrave");
        htmlNoColonEscapeList.add("Eacute");
        htmlNoColonEscapeList.add("Ecirc");
        htmlNoColonEscapeList.add("Euml");
        htmlNoColonEscapeList.add("Igrave");
        htmlNoColonEscapeList.add("Iacute");
        htmlNoColonEscapeList.add("Icirc");
        htmlNoColonEscapeList.add("Iuml");
        htmlNoColonEscapeList.add("ETH");
        htmlNoColonEscapeList.add("Ntilde");
        htmlNoColonEscapeList.add("Ograve");
        htmlNoColonEscapeList.add("Oacute");
        htmlNoColonEscapeList.add("Ocirc");
        htmlNoColonEscapeList.add("Otilde");
        htmlNoColonEscapeList.add("Ouml");
        htmlNoColonEscapeList.add("times");
        htmlNoColonEscapeList.add("Oslash");
        htmlNoColonEscapeList.add("Ugrave");
        htmlNoColonEscapeList.add("Uacute");
        htmlNoColonEscapeList.add("Ucirc");
        htmlNoColonEscapeList.add("Uuml");
        htmlNoColonEscapeList.add("Yacute");
        htmlNoColonEscapeList.add("THORN");
        htmlNoColonEscapeList.add("szlig");
        htmlNoColonEscapeList.add("agrave");
        htmlNoColonEscapeList.add("aacute");
        htmlNoColonEscapeList.add("acirc");
        htmlNoColonEscapeList.add("atilde");
        htmlNoColonEscapeList.add("auml");
        htmlNoColonEscapeList.add("aring");
        htmlNoColonEscapeList.add("aelig");
        htmlNoColonEscapeList.add("ccedil");
        htmlNoColonEscapeList.add("egrave");
        htmlNoColonEscapeList.add("eacute");
        htmlNoColonEscapeList.add("ecirc");
        htmlNoColonEscapeList.add("euml");
        htmlNoColonEscapeList.add("igrave");
        htmlNoColonEscapeList.add("iacute");
        htmlNoColonEscapeList.add("icirc");
        htmlNoColonEscapeList.add("iuml");
        htmlNoColonEscapeList.add("eth");
        htmlNoColonEscapeList.add("ntilde");
        htmlNoColonEscapeList.add("ograve");
        htmlNoColonEscapeList.add("oacute");
        htmlNoColonEscapeList.add("ocirc");
        htmlNoColonEscapeList.add("otilde");
        htmlNoColonEscapeList.add("ouml");
        htmlNoColonEscapeList.add("divide");
        htmlNoColonEscapeList.add("oslash");
        htmlNoColonEscapeList.add("ugrave");
        htmlNoColonEscapeList.add("uacute");
        htmlNoColonEscapeList.add("ucirc");
        htmlNoColonEscapeList.add("uuml");
        htmlNoColonEscapeList.add("yacute");
        htmlNoColonEscapeList.add("thorn");
        htmlNoColonEscapeList.add("yuml");
        htmlEscapeList.addAll(htmlNoColonEscapeList);
        htmlEscapeList.add("OElig");
        htmlEscapeList.add("oelig");
        htmlEscapeList.add("Scaron");
        htmlEscapeList.add("scaron");
        htmlEscapeList.add("Yuml");
        htmlEscapeList.add("fnof");
        htmlEscapeList.add("circ");
        htmlEscapeList.add("tilde");
        htmlEscapeList.add("Alpha");
        htmlEscapeList.add("Beta");
        htmlEscapeList.add("Gamma");
        htmlEscapeList.add("Delta");
        htmlEscapeList.add("Epsilon");
        htmlEscapeList.add("Zeta");
        htmlEscapeList.add("Eta");
        htmlEscapeList.add("Theta");
        htmlEscapeList.add("Iota");
        htmlEscapeList.add("Kappa");
        htmlEscapeList.add("Lambda");
        htmlEscapeList.add("Mu");
        htmlEscapeList.add("Nu");
        htmlEscapeList.add("Xi");
        htmlEscapeList.add("Omicron");
        htmlEscapeList.add("Pi");
        htmlEscapeList.add("Rho");
        htmlEscapeList.add("Sigma");
        htmlEscapeList.add("Tau");
        htmlEscapeList.add("Upsilon");
        htmlEscapeList.add("Phi");
        htmlEscapeList.add("Chi");
        htmlEscapeList.add("Psi");
        htmlEscapeList.add("Omega");
        htmlEscapeList.add("alpha");
        htmlEscapeList.add("beta");
        htmlEscapeList.add("gamma");
        htmlEscapeList.add("delta");
        htmlEscapeList.add("epsilon");
        htmlEscapeList.add("zeta");
        htmlEscapeList.add("eta");
        htmlEscapeList.add("theta");
        htmlEscapeList.add("iota");
        htmlEscapeList.add("kappa");
        htmlEscapeList.add("lambda");
        htmlEscapeList.add("mu");
        htmlEscapeList.add("nu");
        htmlEscapeList.add("xi");
        htmlEscapeList.add("omicron");
        htmlEscapeList.add("pi");
        htmlEscapeList.add("rho");
        htmlEscapeList.add("sigmaf");
        htmlEscapeList.add("sigma");
        htmlEscapeList.add("tau");
        htmlEscapeList.add("upsilon");
        htmlEscapeList.add("phi");
        htmlEscapeList.add("chi");
        htmlEscapeList.add("psi");
        htmlEscapeList.add("omega");
        htmlEscapeList.add("thetasym");
        htmlEscapeList.add("upsih");
        htmlEscapeList.add("piv");
        htmlEscapeList.add("ensp");
        htmlEscapeList.add("emsp");
        htmlEscapeList.add("thinsp");
        htmlEscapeList.add("zwnj");
        htmlEscapeList.add("zwj");
        htmlEscapeList.add("lrm");
        htmlEscapeList.add("rlm");
        htmlEscapeList.add("ndash");
        htmlEscapeList.add("mdash");
        htmlEscapeList.add("lsquo");
        htmlEscapeList.add("rsquo");
        htmlEscapeList.add("sbquo");
        htmlEscapeList.add("ldquo");
        htmlEscapeList.add("rdquo");
        htmlEscapeList.add("bdquo");
        htmlEscapeList.add("dagger");
        htmlEscapeList.add("Dagger");
        htmlEscapeList.add("bull");
        htmlEscapeList.add("hellip");
        htmlEscapeList.add("permil");
        htmlEscapeList.add("prime");
        htmlEscapeList.add("Prime");
        htmlEscapeList.add("lsaquo");
        htmlEscapeList.add("rsaquo");
        htmlEscapeList.add("oline");
        htmlEscapeList.add("frasl");
        htmlEscapeList.add("euro");
        htmlEscapeList.add("image");
        htmlEscapeList.add("weierp");
        htmlEscapeList.add("real");
        htmlEscapeList.add("trade");
        htmlEscapeList.add("alefsym");
        htmlEscapeList.add("larr");
        htmlEscapeList.add("uarr");
        htmlEscapeList.add("rarr");
        htmlEscapeList.add("darr");
        htmlEscapeList.add("harr");
        htmlEscapeList.add("crarr");
        htmlEscapeList.add("lArr");
        htmlEscapeList.add("uArr");
        htmlEscapeList.add("rArr");
        htmlEscapeList.add("dArr");
        htmlEscapeList.add("hArr");
        htmlEscapeList.add("forall");
        htmlEscapeList.add("part");
        htmlEscapeList.add("exist");
        htmlEscapeList.add("empty");
        htmlEscapeList.add("nabla");
        htmlEscapeList.add("isin");
        htmlEscapeList.add("notin");
        htmlEscapeList.add("ni");
        htmlEscapeList.add("prod");
        htmlEscapeList.add("sum");
        htmlEscapeList.add("minus");
        htmlEscapeList.add("lowast");
        htmlEscapeList.add("radic");
        htmlEscapeList.add("prop");
        htmlEscapeList.add("infin");
        htmlEscapeList.add("ang");
        htmlEscapeList.add("and");
        htmlEscapeList.add("or");
        htmlEscapeList.add("cap");
        htmlEscapeList.add("cup");
        htmlEscapeList.add("int");
        htmlEscapeList.add("there4");
        htmlEscapeList.add("sim");
        htmlEscapeList.add("cong");
        htmlEscapeList.add("asymp");
        htmlEscapeList.add("ne");
        htmlEscapeList.add("equiv");
        htmlEscapeList.add("le");
        htmlEscapeList.add("ge");
        htmlEscapeList.add("sub");
        htmlEscapeList.add("sup");
        htmlEscapeList.add("nsub");
        htmlEscapeList.add("sube");
        htmlEscapeList.add("supe");
        htmlEscapeList.add("oplus");
        htmlEscapeList.add("otimes");
        htmlEscapeList.add("perp");
        htmlEscapeList.add("sdot");
        htmlEscapeList.add("lceil");
        htmlEscapeList.add("rceil");
        htmlEscapeList.add("lfloor");
        htmlEscapeList.add("rfloor");
        htmlEscapeList.add("lang");
        htmlEscapeList.add("rang");
        htmlEscapeList.add("loz");
        htmlEscapeList.add("spades");
        htmlEscapeList.add("clubs");
        htmlEscapeList.add("hearts");
        htmlEscapeList.add("diams");
    }
}

