/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee;

import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.CFService;
import coldfusion.server.LicenseService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.j2ee.CFMetricServiceHelper;
import coldfusion.server.j2ee.CFMetricsService;
import coldfusion.server.tomcat.RuntimeHelper;
import coldfusion.util.RB;
import jakarta.servlet.ServletContext;
import java.io.File;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CFServiceImpl
extends CFService {
    private String _appServerRoot;
    private String _javaPolicyFileLocation;
    private String _appServer;
    private ServletContext _context;

    public CFServiceImpl(String rootPath, String appServerRoot, String javaPolicyFileLocation, String appServer, ServletContext context) {
        super(rootPath, context);
        this._appServerRoot = appServerRoot;
        this._appServer = appServer;
        this._javaPolicyFileLocation = javaPolicyFileLocation;
        this._context = context;
    }

    public String getAppServer() {
        return this._appServer;
    }

    @Override
    public void setupMetrics() throws Exception {
        if (_isStandalone) {
            try {
                CFMetricServiceHelper.initMetricsService(CFServiceImpl.getFile("neo-metric.xml"));
            }
            catch (Throwable t) {
                if (CFLogs.SERVER_LOG.isDebugEnabled()) {
                    CFLogs.SERVER_LOG.debug(t);
                }
            }
        } else {
            CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFServiceImpl.server.metrics", (Object)"metrics"));
            this.setDummyMetricsService();
        }
    }

    private void setDummyMetricsService() {
        CFMetricsService metricService = new CFMetricsService();
        ServiceFactory.setMetricsService(metricService);
    }

    public static Object jndiLookup(String name) throws NamingException {
        try (InitialContext ctx = null;){
            ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
    }

    @Override
    public void setupRuntime() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFService.service.start", (Object)"runtime"));
        File comConfig = CFServiceImpl.getFile("neo-comobjmap.xml");
        String comMapperDir = comConfig.getAbsolutePath();
        String rootdir = CFServiceImpl.getRoot();
        File rconfig = CFServiceImpl.getFile("neo-runtime.xml");
        RuntimeServiceImpl rt = _isStandalone ? new RuntimeHelper(rconfig, rootdir, this.getAppServer(), this._context.getContextPath()) : new RuntimeServiceImpl(rconfig, rootdir, this.getAppServer(), this._context.getContextPath());
        rt.setComMapperDir(comMapperDir);
        rt.setRegistryDir(CFServiceImpl.getRegistryDir());
        rt.setWebRoot(this._context.getRealPath("/"));
        rt.setWEBINF(this._context.getRealPath("/WEB-INF"));
        rt.setCFIDE(this._context.getRealPath("/CFIDE"));
        rt.setupServiceTagAttributesSubScope(this._context.getRealPath("/WEB-INF"));
        rt.start();
        ServiceFactory.setRuntimeService(rt);
        LicenseService ls = ServiceFactory.getLicenseService();
        if (ls != null && ls.isStandard()) {
            FeatureRouter fr = FeatureRouter.getInstance();
            if (rt.getCorePoolSize() > fr.getServerEdition().getDefaultCorePoolSize()) {
                rt.setCorePoolSize(fr.getServerEdition().getDefaultCorePoolSize());
            }
            if (rt.getMaxPoolSize() > fr.getServerEdition().getDefaultMaxPoolSize()) {
                rt.setMaxPoolSize(fr.getServerEdition().getDefaultMaxPoolSize());
            }
            int corePoolSize = rt.getCloudServicesThreadPoolCorePoolSize();
            int defaultCorePoolSize = fr.getServerEdition().getDefaultCloudServicesCorePoolSize();
            int maxPoolSize = rt.getCloudServicesThreadPoolMaxPoolSize();
            int defaultMaxPoolSize = fr.getServerEdition().getDefaultCloudServicesMaxPoolSize();
            if (corePoolSize > defaultCorePoolSize && maxPoolSize > defaultMaxPoolSize) {
                rt.setCloudServicesThreadPoolConfiguration(defaultCorePoolSize, defaultMaxPoolSize, rt.getCloudServicesThreadPoolKeepAliveTime());
            } else if (corePoolSize > defaultCorePoolSize) {
                rt.setCloudServicesThreadPoolConfiguration(defaultCorePoolSize, maxPoolSize, rt.getCloudServicesThreadPoolKeepAliveTime());
            } else if (maxPoolSize > defaultMaxPoolSize) {
                rt.setCloudServicesThreadPoolConfiguration(corePoolSize, defaultMaxPoolSize, rt.getCloudServicesThreadPoolKeepAliveTime());
            }
        }
    }
}

