/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee;

import coldfusion.server.CFService;
import coldfusion.server.ServiceException;
import coldfusion.server.SystemInfo;
import coldfusion.util.OrderedProperties;
import coldfusion.util.Utils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;

public final class SecurityHelper {
    private String java_policy;
    private String jaas_policy;
    private String jvm_config;
    private boolean isJRun = false;

    public SecurityHelper(CFService service, boolean isJRun) {
        this.isJRun = isJRun;
        this.jvm_config = service.getJvmConfigFile();
        this.java_policy = Utils.getCanonicalPath(service.getJavaPolicyFile());
        this.jaas_policy = Utils.getCanonicalPath(service.getJassPolicyFile());
    }

    public SecurityHelper(String jvmConf, String javaPolicy, String jaasPolicy, boolean isJRun) {
        this.isJRun = isJRun;
        this.jvm_config = jvmConf;
        this.java_policy = javaPolicy;
        this.jaas_policy = jaasPolicy;
    }

    public void setSanboxSecuritySwitches(boolean bEnabled) throws ServiceException {
        if (!SystemInfo.isStandalone()) {
            return;
        }
        OrderedProperties p = new OrderedProperties();
        try {
            p.load(this.getJVMFileInputStream());
            String vmArgs = p.getProperty("java.args");
            if (bEnabled) {
                if (vmArgs.indexOf("-Djava.security.manager") != -1) {
                    return;
                }
                if (SystemInfo.isMac()) {
                    p.setProperty("java.args", this.removeSecurityProperty(vmArgs).trim() + " -Djava.security.manager -Djava.security.policy=" + this.java_policy + " -Djava.security.auth.policy=" + this.jaas_policy);
                } else {
                    p.setProperty("java.args", this.removeSecurityProperty(vmArgs).trim() + " -Djava.security.manager \"-Djava.security.policy=" + this.java_policy + "\" \"-Djava.security.auth.policy=" + this.jaas_policy + "\" ");
                }
            } else {
                if (vmArgs.indexOf("-Djava.security.manager") == -1) {
                    return;
                }
                p.setProperty("java.args", this.removeSecurityProperty(vmArgs).trim());
            }
            p.store(this.getJVMFileOutputStream());
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    private FileInputStream getJVMFileInputStream() throws ServiceException {
        FileInputStream fis;
        try {
            fis = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileInputStream(SecurityHelper.this.jvm_config);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ServiceException(pae.getException());
        }
        return fis;
    }

    private FileOutputStream getJVMFileOutputStream() throws ServiceException {
        FileOutputStream fos;
        try {
            fos = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileOutputStream(SecurityHelper.this.jvm_config);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ServiceException(pae.getException());
        }
        return fos;
    }

    private String removeSecurityProperty(String vmArgs) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(vmArgs, " \t");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf("-Djava.security.manager") != -1 || t.indexOf("-Djava.security.policy") != -1 || t.indexOf("-Djava.security.auth.policy") != -1) continue;
            buffer.append(t);
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

