/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.pool;

import coldfusion.monitor.util.AvgStatCalculator;
import coldfusion.server.j2ee.pool.Pool;
import coldfusion.server.j2ee.pool.PoolMetaData;
import coldfusion.server.j2ee.pool.PoolSkimmerThread;
import coldfusion.server.j2ee.pool.PooledObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ObjectPool
implements Pool {
    protected final PoolMetaData metadata;
    protected int count;
    protected final Hashtable locked;
    protected final Hashtable unlocked;
    private Thread skimmer;
    private PoolSkimmerThread poolSkimmerThread;
    private AvgStatCalculator avgCount = new AvgStatCalculator();
    private AvgStatCalculator avgLocked = new AvgStatCalculator();

    public ObjectPool(PoolMetaData metad) {
        this.metadata = metad;
        this.locked = new Hashtable(1);
        this.unlocked = new Hashtable(1);
    }

    public void init() throws Exception {
        if (this.metadata.getInitialObjects() > 0 && !this.metadata.isDisablePooling()) {
            int i;
            ArrayList<Object> initialObjects = new ArrayList<Object>();
            for (i = 0; i < this.metadata.getInitialObjects(); ++i) {
                initialObjects.add(this.checkOut());
            }
            for (i = 0; i < initialObjects.size(); ++i) {
                this.checkIn(initialObjects.get(i));
            }
        }
        this.avgCount.updateData(this.count);
        if (!this.metadata.isDisablePooling() && this.metadata.getSkimmerFrequency() > 0 && this.metadata.getObjectTimeout() > 0) {
            this.poolSkimmerThread = new PoolSkimmerThread(this.metadata.getSkimmerFrequency(), this);
            this.skimmer = new Thread((Runnable)this.poolSkimmerThread, "obj-skimmer-" + this.metadata.getName());
            this.skimmer.setDaemon(true);
            this.skimmer.start();
        }
    }

    protected abstract Object create() throws Exception;

    protected abstract boolean validate(Object var1);

    protected boolean holdingLock(Object o) {
        return false;
    }

    protected void expire(Object o) {
        if (o instanceof PooledObject) {
            ((PooledObject)o).closeAllResources();
        }
    }

    public abstract void closeConnection(Object var1);

    @Override
    public final String getPoolname() {
        return this.metadata.getName();
    }

    public final int getPoolCount() {
        return this.count;
    }

    public final int getCheckedOutCount() {
        return this.locked.size();
    }

    public PoolMetaData getMetaData() {
        return this.metadata;
    }

    public AvgStatCalculator getPoolCountCalculator() {
        return this.avgCount;
    }

    public AvgStatCalculator getCheckedOutCountCalculator() {
        return this.avgLocked;
    }

    private synchronized Object checkOutNoWait() throws Exception {
        long now = System.currentTimeMillis();
        Object o = null;
        if (this.unlocked.size() > 0) {
            Enumeration e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (this.validate(o)) {
                    this.unlocked.remove(o);
                    this.locked.put(o, new Long(now));
                    break;
                }
                --this.count;
                this.unlocked.remove(o);
                this.expire(o);
                o = null;
            }
        }
        if (o != null) {
            this.avgCount.updateData(this.count);
            this.avgLocked.updateData(this.locked.size());
            return o;
        }
        if (this.count < this.metadata.getMaximumSize()) {
            o = this.create();
            this.locked.put(o, new Long(now));
            ++this.count;
            this.avgCount.updateData(this.count);
            this.avgLocked.updateData(this.locked.size());
            return o;
        }
        if (this.metadata.isMaximumSoft()) {
            o = this.create();
            this.locked.put(o, new Long(now));
            ++this.count;
            this.avgCount.updateData(this.count);
            this.avgLocked.updateData(this.locked.size());
            return o;
        }
        o = null;
        return o;
    }

    @Override
    public synchronized Object checkOut() throws Exception {
        Object o = this.checkOutNoWait();
        if (o != null) {
            return o;
        }
        do {
            this.wait(3000L);
        } while ((o = this.checkOutNoWait()) == null);
        return o;
    }

    @Override
    public final synchronized void checkIn(Object o) {
        if (this.metadata.isDisablePooling()) {
            this.expire(o);
            this.locked.remove(o);
            --this.count;
        } else {
            this.locked.remove(o);
            this.unlocked.put(o, new Long(System.currentTimeMillis()));
            if (!this.metadata.isMaximumSoft()) {
                this.notifyAll();
            }
        }
        this.avgCount.updateData(this.count);
        this.avgLocked.updateData(this.locked.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateLocked(PooledObject o) {
        Hashtable hashtable = this.locked;
        synchronized (hashtable) {
            if (this.locked.containsKey(o)) {
                this.locked.put(o, new Long(System.currentTimeMillis()));
            }
        }
    }

    final synchronized void cleanUp() {
        int minSize = this.metadata.getMinimumSize();
        if (this.unlocked.size() <= minSize) {
            return;
        }
        int maxSize = this.metadata.getMaximumSize();
        int shrinkBy = this.metadata.getShrinkBy();
        if (shrinkBy < 1) {
            shrinkBy = 5;
        }
        int shrunken = 0;
        try {
            long now = System.currentTimeMillis();
            ArrayList unlockedObjects = new ArrayList();
            Enumeration keysEnum = this.unlocked.keys();
            while (keysEnum.hasMoreElements()) {
                unlockedObjects.add(keysEnum.nextElement());
            }
            for (int i = 0; i < unlockedObjects.size(); ++i) {
                Object o = unlockedObjects.get(i);
                long lasttouch = (Long)this.unlocked.get(o);
                if (now - lasttouch > (long)(1000 * this.metadata.getObjectTimeout())) {
                    this.unlocked.remove(o);
                    this.closeConnection(o);
                    --this.count;
                    ++shrunken;
                    o = null;
                }
                if (this.unlocked.size() <= minSize) {
                    this.avgCount.updateData(this.count);
                    return;
                }
                if (shrunken < shrinkBy || this.unlocked.size() + this.locked.size() > maxSize) continue;
                this.avgCount.updateData(this.count);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void closeAllResources() {
        Object o;
        Enumeration keysEnum = this.unlocked.keys();
        while (keysEnum.hasMoreElements()) {
            o = keysEnum.nextElement();
            this.expire(o);
        }
        keysEnum = this.locked.keys();
        while (keysEnum.hasMoreElements()) {
            o = keysEnum.nextElement();
            this.expire(o);
        }
        this.avgCount.reset();
        this.avgLocked.reset();
    }

    public void destroy() {
        this.closeAllResources();
        this.cleanUp();
        if (this.poolSkimmerThread != null) {
            this.poolSkimmerThread.shutdown();
            this.skimmer.interrupt();
            this.poolSkimmerThread = null;
        }
        this.skimmer = null;
    }

    public final void finalize() {
        this.closeAllResources();
        if (this.poolSkimmerThread != null) {
            this.poolSkimmerThread.shutdown();
        }
    }
}

