/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.pool;

import coldfusion.log.CFLogs;
import coldfusion.server.j2ee.pool.ObjectPool;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;

public class PoolManager
implements Serializable {
    private final FastHashtable pools = new FastHashtable(1);

    protected PoolManager() {
    }

    public Enumeration getAllPoolnames() {
        return this.pools.keys();
    }

    public ObjectPool getPool(String name) throws SQLException {
        if (name == null) {
            return null;
        }
        if (this.pools.containsKey(name)) {
            try {
                return (ObjectPool)this.pools.get(name);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
        throw new SQLException(RB.getString(PoolManager.class, "PoolManager.lostPoolError", (Object)name));
    }

    public Enumeration getPools() {
        return this.pools.elements();
    }

    public void addPool(String id, ObjectPool newpool) {
        if (this.pools.containsKey(id)) {
            CFLogs.SERVER_LOG.error(RB.getString(PoolManager.class, "PoolManager.duplicatePoolError", (Object)id));
        } else {
            this.pools.put(id, (Object)newpool);
        }
    }

    public Object removePool(String id) {
        return this.pools.remove(id);
    }
}

