/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql;

import coldfusion.server.j2ee.pool.ObjectPool;
import coldfusion.server.j2ee.pool.PooledObject;
import coldfusion.server.j2ee.sql.JRunCallableStatement;
import coldfusion.server.j2ee.sql.JRunConnectionHandle;
import coldfusion.server.j2ee.sql.JRunPreparedStatement;
import coldfusion.server.j2ee.sql.JRunStatement;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import coldfusion.server.j2ee.sql.pool.PooledStatementKey;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import javax.transaction.xa.Xid;

public class JRunConnection
implements PooledObject,
PooledConnection {
    private static final long serialVersionUID = 1L;
    private static final String MACROMEDIA = "macromedia.";
    private JDBCPool mypool;
    private Connection con;
    private JRunConnectionHandle handle;
    private WeakHashMap openstatements;
    private ArrayList listeners;
    private boolean readOnly = false;
    private boolean connectionError = false;
    private boolean tmControlled = false;
    private ArrayList nested;
    private HashMap suspended;
    private String username;
    private String password;
    private boolean isMacromediaDriver = false;
    private int jdbcMajorVersion = 3;
    private boolean isJDBC4Supported = false;

    public JRunConnection(Connection con, ObjectPool pool) {
        this.con = con;
        if (this.con.getClass().getName().toLowerCase().startsWith(MACROMEDIA)) {
            this.isMacromediaDriver = true;
        }
        try {
            this.jdbcMajorVersion = this.con.getMetaData().getJDBCMajorVersion();
            if (this.jdbcMajorVersion >= 4) {
                this.isJDBC4Supported = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.mypool = (JDBCPool)pool;
        this.openstatements = new WeakHashMap();
        try {
            if (con.isReadOnly()) {
                this.readOnly = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    final synchronized void suspend(Xid xid) throws Exception {
        if (this.suspended == null) {
            this.suspended = new HashMap();
        }
        if (this.nested == null) {
            this.nested = new ArrayList();
        }
        this.suspended.put(xid, this.con);
        JRunConnectionHandle jrunConnectionHandle = (JRunConnectionHandle)this.mypool.requestConnection();
        this.con = jrunConnectionHandle.getPhysicalConnection();
        this.nested.add(jrunConnectionHandle);
    }

    final synchronized void resume(Xid xid) throws Exception {
        try {
            ((Connection)this.nested.get(this.nested.size() - 1)).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.con = (Connection)this.suspended.get(xid);
    }

    final boolean hasSuspended(Xid xid) {
        try {
            return this.suspended.containsKey(xid);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValid() {
        return this.mypool.validateJRunConnection(this);
    }

    public boolean isTmControlled() {
        return this.tmControlled;
    }

    public void setTmControlled(boolean tmControlled) {
        this.tmControlled = tmControlled;
    }

    @Override
    public void closeAllResources() {
        this.clean();
    }

    public void closeAll() {
    }

    public void removeOpenStatement(JRunStatement s) {
        if (this.openstatements.containsKey(s)) {
            this.openstatements.remove(s);
        }
    }

    @Override
    public boolean clean() {
        if (!this.tmControlled) {
            if (this.handle != null) {
                this.handle.clearConnection();
                this.handle = null;
            }
            try {
                this.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setTransactionIsolation(this.mypool.getIsolationLevel());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.con.setReadOnly(this.readOnly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Object[] stmts = this.openstatements.keySet().toArray();
            for (int i = 0; i < stmts.length; ++i) {
                ((JRunStatement)stmts[i]).clean();
                JDBCPool.closeStatement((JRunStatement)stmts[i]);
            }
        }
        return !this.tmControlled;
    }

    public void touch() {
        this.mypool.updateLocked(this);
    }

    @Override
    public ObjectPool getPool() {
        return this.mypool;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.handle == null) {
            this.handle = new JRunConnectionHandle(this);
        }
        return this.handle;
    }

    public Connection getPhysicalConnection() {
        return this.con;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (null == this.listeners) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        try {
            this.listeners.remove(listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendCloseEvent() {
        ConnectionEvent pev = new ConnectionEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener l = (ConnectionEventListener)this.listeners.get(i);
            l.connectionClosed(pev);
        }
    }

    private void sendErrorEvent(SQLException sqle) {
        ConnectionEvent pev = new ConnectionEvent(this, sqle);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener l = (ConnectionEventListener)this.listeners.get(i);
            l.connectionErrorOccurred(pev);
        }
    }

    public Statement createStatement() throws SQLException {
        this.touch();
        try {
            Statement s = this.con.createStatement();
            JRunStatement sst = new JRunStatement(this, s, this.mypool);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.touch();
        try {
            PooledStatementKey poolKey = new PooledStatementKey(sql);
            PreparedStatement ps = this.mypool.requestPooledStatement(poolKey, this.con);
            if (ps == null) {
                ps = this.con.prepareStatement(sql);
            }
            JRunPreparedStatement sst = new JRunPreparedStatement(this, ps, sql, this.mypool, poolKey);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.touch();
        try {
            CallableStatement s = this.con.prepareCall(sql);
            JRunCallableStatement sst = new JRunCallableStatement(this, s, sql, this.mypool);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            String s = this.con.nativeSQL(sql);
            return s;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void commit() throws SQLException {
        try {
            this.con.commit();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void rollback() throws SQLException {
        try {
            this.con.rollback();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.clean();
            this.mypool.cleanPooledStatements(this.con);
            this.con.close();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            return this.con.isClosed();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            return true;
        }
    }

    public boolean isValid(int timeout) {
        try {
            return this.con.isValid(timeout);
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.con.getMetaData();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.con.getCatalog();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        block5: {
            try {
                this.con.setTransactionIsolation(level);
            }
            catch (SQLException sqle) {
                DatabaseMetaData dbMeta = this.con.getMetaData();
                boolean supportsTxIsolationLevel = false;
                try {
                    supportsTxIsolationLevel = dbMeta.supportsTransactionIsolationLevel(level);
                    String driverName = dbMeta.getDriverName();
                    if (this.mypool.getDriver().equals("macromedia.jdbc.MacromediaDriver") && ("DB2".equals(driverName) || "Informix".equals(driverName)) && supportsTxIsolationLevel) {
                        supportsTxIsolationLevel = false;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!supportsTxIsolationLevel) break block5;
                this.sendErrorEvent(sqle);
                throw sqle;
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.con.getWarnings();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.con.clearWarnings();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.touch();
        try {
            Statement s = this.mypool.isUsingNativeResults() ? this.con.createStatement(resultSetType, resultSetConcurrency) : this.con.createStatement();
            JRunStatement sst = new JRunStatement(this, s, this.mypool);
            sst.setResultSetType(resultSetType);
            sst.setResultSetConcurrency(resultSetConcurrency);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.touch();
        try {
            PooledStatementKey poolKey = new PooledStatementKey(sql, resultSetType, resultSetConcurrency, 0);
            PreparedStatement ps = this.mypool.requestPooledStatement(poolKey, this.con);
            if (ps == null) {
                ps = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            JRunPreparedStatement sst = new JRunPreparedStatement(this, ps, sql, this.mypool, poolKey);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.touch();
        try {
            CallableStatement s = this.con.prepareCall(sql);
            JRunCallableStatement sst = new JRunCallableStatement(this, s, (ObjectPool)this.mypool);
            sst.setResultSetType(resultSetType);
            sst.setResultSetConcurrency(resultSetConcurrency);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public boolean isMacromediaDriver() {
        return this.isMacromediaDriver;
    }

    public boolean isJDBC4Supported() {
        return this.isJDBC4Supported;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isConnectionError() {
        return this.connectionError;
    }

    public void setConnectionError(boolean connectionError) {
        this.connectionError = connectionError;
    }

    public String toString() {
        return "JRunConnection:[Pool:" + this.mypool.getPoolname() + ",Open Satements:" + this.openstatements.size() + "]";
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.touch();
        try {
            Statement s = this.mypool.isUsingNativeResults() ? this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability) : this.con.createStatement();
            JRunStatement sst = new JRunStatement(this, s, this.mypool);
            sst.setResultSetType(resultSetType);
            sst.setResultSetConcurrency(resultSetConcurrency);
            sst.setResultSetHoldability(resultSetHoldability);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public int getHoldability() throws SQLException {
        try {
            return this.con.getHoldability();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.touch();
        try {
            CallableStatement s = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            JRunCallableStatement sst = new JRunCallableStatement(this, s, (ObjectPool)this.mypool);
            sst.setResultSetType(resultSetType);
            sst.setResultSetConcurrency(resultSetConcurrency);
            sst.setResultSetHoldability(resultSetHoldability);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.touch();
        try {
            PooledStatementKey poolKey = new PooledStatementKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            PreparedStatement ps = this.mypool.requestPooledStatement(poolKey, this.con);
            if (ps == null) {
                ps = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            JRunPreparedStatement sst = new JRunPreparedStatement(this, ps, sql, this.mypool, poolKey);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            if (this.con != null) {
                this.rollback();
            }
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.touch();
        try {
            PooledStatementKey poolKey = new PooledStatementKey(sql, autoGeneratedKeys);
            PreparedStatement ps = this.mypool.requestPooledStatement(poolKey, this.con);
            if (ps == null) {
                ps = this.con.prepareStatement(sql, autoGeneratedKeys);
            }
            JRunPreparedStatement sst = new JRunPreparedStatement(this, ps, sql, this.mypool, poolKey);
            this.openstatements.put(sst, null);
            return sst;
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("JRunConnection.prepareStatement(String, int[])");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("JRunConnection.prepareStatement(String, String[])");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.con.rollback(savepoint);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this.con.setHoldability(holdability);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.con.setSavepoint(name);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener l) {
        try {
            this.listeners.remove(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener l) {
        if (null == this.listeners) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(l);
    }

    public Struct createStruct(String s, Object[] o) throws SQLException {
        this.touch();
        try {
            return this.con.createStruct(s, o);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Array createArrayOf(String s, Object[] o) throws SQLException {
        this.touch();
        try {
            return this.con.createArrayOf(s, o);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Properties getClientInfo() throws SQLException {
        try {
            return this.con.getClientInfo();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public String getClientInfo(String s) throws SQLException {
        try {
            return this.con.getClientInfo(s);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setClientInfo(Properties p) throws SQLClientInfoException {
        this.touch();
        try {
            this.con.setClientInfo(p);
        }
        catch (SQLClientInfoException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public void setClientInfo(String s1, String s2) throws SQLClientInfoException {
        this.touch();
        try {
            this.con.setClientInfo(s1, s2);
        }
        catch (SQLClientInfoException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Blob createBlob() throws SQLException {
        this.touch();
        try {
            return this.con.createBlob();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public Clob createClob() throws SQLException {
        this.touch();
        try {
            return this.con.createClob();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public boolean isWrapperFor(Class<?> c) throws SQLException {
        try {
            return this.con.isWrapperFor(c);
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.con.unwrap(iface);
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public NClob createNClob() throws SQLException {
        this.touch();
        try {
            return this.con.createNClob();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }

    public SQLXML createSQLXML() throws SQLException {
        this.touch();
        try {
            return this.con.createSQLXML();
        }
        catch (SQLException sqle) {
            this.sendErrorEvent(sqle);
            throw sqle;
        }
    }
}

