/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql;

import coldfusion.server.j2ee.sql.JRunConnection;
import coldfusion.util.RB;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class JRunConnectionHandle
implements Connection,
PooledConnection,
Serializable {
    private static final long serialVersionUID = 1L;
    private JRunConnection pcon;

    public JRunConnectionHandle(JRunConnection c) {
        this.pcon = c;
    }

    void clearConnection() {
        this.pcon = null;
    }

    void assertConnectionExists() throws SQLException {
        if (this.pcon == null) {
            throw new SQLException(RB.getString(JRunConnectionHandle.class, "JRunConnectionHandle.timeout"));
        }
    }

    @Override
    public void close() throws SQLException {
        this.assertConnectionExists();
        this.pcon.sendCloseEvent();
    }

    public Connection getPhysicalConnection() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getPhysicalConnection();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.assertConnectionExists();
        this.pcon.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.assertConnectionExists();
        this.pcon.rollback();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.pcon == null || this.pcon.isTmControlled();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertConnectionExists();
        this.pcon.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetPconcurrency) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.createStatement(resultSetType, resultSetPconcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetPconcurrency) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(sql, resultSetType, resultSetPconcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetPconcurrency) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareCall(sql, resultSetType, resultSetPconcurrency);
    }

    public Map getTypeMap() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setTypeMap(map);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.pcon != null) {
            this.pcon.addConnectionEventListener(listener);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.pcon != null) {
            this.pcon.removeConnectionEventListener(listener);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getConnection();
    }

    public String toString() {
        return "JRunConnectionHandle-" + this.pcon.toString();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.getHoldability();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.prepareStatement(sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertConnectionExists();
        this.pcon.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertConnectionExists();
        this.pcon.rollback(savepoint);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.assertConnectionExists();
        this.pcon.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.assertConnectionExists();
        return this.pcon.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertConnectionExists();
        return this.pcon.setSavepoint(name);
    }

    public boolean isMacromediaDriver() {
        return this.pcon.isMacromediaDriver();
    }

    public boolean isJDBC4Supported() {
        return this.pcon.isJDBC4Supported();
    }

    @Override
    public Struct createStruct(String s, Object[] o) throws SQLException {
        return this.pcon.createStruct(s, o);
    }

    @Override
    public Array createArrayOf(String s, Object[] o) throws SQLException {
        return this.pcon.createArrayOf(s, o);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.pcon.getClientInfo();
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        return this.pcon.getClientInfo(s);
    }

    @Override
    public void setClientInfo(Properties p) throws SQLClientInfoException {
        this.pcon.setClientInfo(p);
    }

    @Override
    public void setClientInfo(String s1, String s2) throws SQLClientInfoException {
        this.pcon.setClientInfo(s1, s2);
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        return this.pcon.isValid(i);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.pcon.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.pcon.createClob();
    }

    @Override
    public boolean isWrapperFor(Class<?> c) throws SQLException {
        return this.pcon.isWrapperFor(c);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.pcon.unwrap(iface);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener s) {
        if (this.pcon != null) {
            this.pcon.removeStatementEventListener(s);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener s) {
        if (this.pcon != null) {
            this.pcon.addStatementEventListener(s);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.pcon.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.pcon.createSQLXML();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.pcon.getConnection().getNetworkTimeout();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.clearConnection();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.pcon.getConnection().getSchema();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.pcon.getConnection().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.pcon.getConnection().setSchema(schema);
    }
}

