/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql.pool;

import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.osgi.services.ApacheDerbyService;
import coldfusion.osgi.services.PostgreSQLDriverService;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.server.j2ee.pool.ObjectPool;
import coldfusion.server.j2ee.pool.PoolMetaData;
import coldfusion.server.j2ee.sql.JRunConnection;
import coldfusion.server.j2ee.sql.JRunDataSource;
import coldfusion.server.j2ee.sql.JRunPreparedStatement;
import coldfusion.server.j2ee.sql.pool.ConnectionRunner;
import coldfusion.server.j2ee.sql.pool.JDBCPoolMetaData;
import coldfusion.server.j2ee.sql.pool.PooledStatementKey;
import coldfusion.server.j2ee.sql.pool.TwoFishCryptor;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.sql.DatabaseConnectionException;
import coldfusion.util.RB;
import java.io.FilePermission;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.SocketPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import macromedia.jdbc.DriverNotSupportedException;
import macromedia.jdbc.MacromediaDriver;

public class JDBCPool
extends ObjectPool
implements ConnectionEventListener {
    private static final long serialVersionUID = 1L;
    private JRunDataSource datasource;
    private boolean deployedDataSource = false;
    private JDBCPoolMetaData info = (JDBCPoolMetaData)this.metadata;
    private Hashtable<PooledStatementKey, Object> preparedStatementPool = new Hashtable();
    private ReferenceQueue refQ = new ReferenceQueue();
    private TwoFishCryptor encrypter;
    private static final SocketPermission SQL_SERVER_NAMED_INSTANCE_ACCEPT_PERMISSION = new SocketPermission("*", "accept");

    public JDBCPoolMetaData getJDBCPoolMetaData() {
        return this.info;
    }

    public JDBCPool(PoolMetaData metad) {
        super(metad);
        if (null != this.info.getJNDIName()) {
            this.datasource = new JRunDataSource(this.info.getDbname(), this.info.getJNDIName());
        } else {
            System.out.println(RB.getString((Object)this, "JDBCPool.noJNDI", (Object)this.info.getDbname()));
        }
        try {
            this.init();
        }
        catch (Exception e) {
            System.err.println(RB.getString(this, "JDBCPool.initError"));
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void init() throws Exception {
        this.info.init();
        this.initEncrypter();
        String initConSQL = this.info.getInitialConnectionSql();
        super.init();
        if (this.info.getInitialPoolSql() != null) {
            try {
                JRunConnection pc = (JRunConnection)this.create();
                Connection c = pc.getPhysicalConnection();
                Statement s = c.createStatement();
                s.execute(this.info.getInitialPoolSql());
            }
            catch (SQLException sqe) {
                throw new SQLException(RB.getString((Object)this, "JDBCPool.initSQLError", (Object)sqe.toString()));
            }
        }
        this.info.setInitialConnectionSql(initConSQL);
        if (this.info.isDisablePooling()) {
            this.info.setPoolStatements(false);
        }
        this.deployDataSource();
    }

    public void setDataSource(JRunDataSource ds) {
        this.datasource = ds;
    }

    public DataSource getDataSource() throws SQLException {
        if (this.datasource == null) {
            throw new SQLException(RB.getString((Object)this, "JDBCPool.noDataSource", (Object)this.info.getDbname()));
        }
        return this.datasource;
    }

    public void deployDataSource() {
        if (this.datasource == null) {
            return;
        }
        try {
            InitialContext ctx = new InitialContext();
            String jndiName = this.info.getJNDIName();
            this.deployedDataSource = true;
        }
        catch (Exception e) {
            System.err.println(RB.getString((Object)this, "JDBCPool.unableToBind", (Object)this.info.getJNDIName(), (Object)e.getMessage()));
        }
    }

    public void undeployDataSource() {
        if (this.datasource == null) {
            return;
        }
        try {
            this.deployedDataSource = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isDataSourceDeployed() {
        return this.deployedDataSource;
    }

    public void initEncrypter() {
        this.encrypter = new TwoFishCryptor();
    }

    public String getDriver() {
        return this.info.getDriver();
    }

    public String getURL() {
        return this.info.getURL();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public String getPassword() {
        return this.info.getPassword();
    }

    public int getIsolationLevel() {
        int isolationLevel = 2;
        try {
            isolationLevel = this.info.getIntIsolationLevel();
        }
        catch (Exception metaDataException) {
            System.err.println(metaDataException.getMessage());
        }
        return isolationLevel;
    }

    public boolean isUsingNativeResults() {
        return this.info.isNativeResults();
    }

    public String getTransactionDomain() {
        return this.info.getTransactionDomain();
    }

    public boolean equals(Object o) {
        try {
            JDBCPool p = (JDBCPool)o;
            if (p.getURL().equals(this.getURL()) && p.getUserName().equals(this.getUserName()) && p.getPassword().equals(this.getPassword()) && p.getDriver().equals(this.getDriver())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void checkCredentials(String username, String password) throws SQLException {
        if (this.info.getUserName().equals(username) && (this.info.isEncrypted() ? this.encrypter.decrypt(this.getPassword()) : this.getPassword()).equals(password)) {
            throw new SQLException(RB.getString((Object)this, "JDBCPool.credentialsFailed", (Object)username, (Object)password));
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        this.returnConnection((JRunConnection)event.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.info.isRemoveOnExceptions()) {
            JRunConnection pcon = (JRunConnection)event.getSource();
            if (pcon.isConnectionError()) {
                return;
            }
            try {
                Connection c = pcon.getPhysicalConnection();
                c.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                pcon.setConnectionError(true);
                this.returnConnection(pcon);
                System.out.println(RB.getString((Object)this, "JDBCPool.removedOnException", (Object)this.info.getDbname()));
            }
        }
    }

    protected synchronized Object checkOut(String username, String password) throws Exception {
        Object obj = null;
        int timeout = this.getDataSource().getLoginTimeout();
        if (timeout < 1) {
            timeout = 30;
        }
        for (int i = 0; i < timeout; ++i) {
            obj = this._checkOut(username, password);
            if (obj != null) {
                return obj;
            }
            this.wait(1000L);
        }
        throw new DatabaseConnectionException(new Exception("Timeout trying to create pooled connection for " + this.info.getName()));
    }

    protected synchronized Object _checkOut(String username, String password) throws Exception {
        long now = System.currentTimeMillis();
        Object o = null;
        Iterator itr = this.unlocked.entrySet().iterator();
        Map.Entry oldest = null;
        if (this.unlocked.size() > 0) {
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                o = entry.getKey();
                if (oldest == null) {
                    oldest = entry;
                } else {
                    Long thisguy;
                    Long maxg = (Long)oldest.getValue();
                    if (maxg.compareTo(thisguy = (Long)entry.getValue()) > 0) {
                        oldest = entry;
                    }
                }
                if (!this.holdingLock(o)) {
                    if (this.matchSecurityInfo(username, password, o)) {
                        if (this.validate(o)) {
                            itr.remove();
                            this.locked.put(o, new Long(now));
                            break;
                        }
                        --this.count;
                        itr.remove();
                        this.expire(o);
                        o = null;
                        continue;
                    }
                    o = null;
                    continue;
                }
                o = null;
            }
        }
        if (o != null) {
            return o;
        }
        if (this.count < this.metadata.getMaximumSize()) {
            o = this.create(username, password);
            this.locked.put(o, new Long(now));
            ++this.count;
            return o;
        }
        if (this.unlocked.size() > 0) {
            Object oldConn = oldest.getKey();
            this.unlocked.remove(oldConn);
            this.expire(oldConn);
            o = this.create(username, password);
            this.locked.put(o, new Long(now));
            return o;
        }
        if (this.metadata.isMaximumSoft()) {
            o = this.create(username, password);
            this.locked.put(o, new Long(now));
            ++this.count;
            return o;
        }
        return null;
    }

    @Override
    protected boolean holdingLock(Object o) {
        try {
            JRunConnection jRunConnection = (JRunConnection)o;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected Object create() throws SQLException {
        return this.create(this.info.getUserName(), this.info.isEncrypted() ? this.encrypter.decrypt(this.info.getPassword()) : this.info.getPassword());
    }

    protected Object create(String username, String password) throws SQLException {
        int timeout = this.getDataSource().getLoginTimeout();
        Connection con = null;
        if (timeout > 0) {
            ConnectionRunner cRun = new ConnectionRunner();
            con = cRun.fetchConnection(this, username, password, timeout);
        } else {
            con = this.createPhysicalConnection(username, password);
        }
        JRunConnection pcon = new JRunConnection(con, this);
        pcon.addConnectionEventListener(this);
        pcon.setUsername(username);
        pcon.setPassword(password);
        return pcon;
    }

    protected Connection createPhysicalConnection(final String username, final String password) throws SQLException, DriverNotSupportedException {
        Connection con;
        block32: {
            if (this.info.getDriver() == null || this.info.getURL() == null) {
                throw new SQLException(RB.getString(this, "JDBCPool.noDriver"));
            }
            con = null;
            try {
                Object classLoader = ServerlessUtil.isLambdaEnv() ? BootstrapClassLoader.instance() : Thread.currentThread().getContextClassLoader();
                final Driver d = (Driver)Class.forName(this.info.getDriver(), true, (ClassLoader)classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (d.acceptsURL(this.info.getURL())) {
                    final Properties p = new Properties();
                    ApacheDerbyService derbyService = ServiceFactory.getApacheDerbyService();
                    if (username != null) {
                        if (derbyService != null && derbyService.isApacheDerbyDriver(d)) {
                            if (username.length() > 0) {
                                p.put("user", username);
                            }
                        } else {
                            p.put("user", username);
                        }
                    }
                    if (password != null) {
                        if (derbyService != null && derbyService.isApacheDerbyDriver(d)) {
                            if (password.length() > 0) {
                                p.put("password", password);
                            }
                        } else {
                            p.put("password", password);
                        }
                    }
                    if (System.getSecurityManager() != null) {
                        if (this.info.getDriver().equals("org.postgresql.Driver")) {
                            final PostgreSQLDriverService posrgres = ServiceFactory.getPostgreSQLDriverService(true);
                            con = AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                                @Override
                                public Connection run() throws SQLException {
                                    return posrgres.connect(JDBCPool.this.info.getURL(), p);
                                }
                            }, null, this.getPermissions());
                        }
                        con = AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws SQLException {
                                return d.connect(JDBCPool.this.info.getURL(), p);
                            }
                        }, null, this.getPermissions());
                    } else if (this.info.getDriver().equals("org.postgresql.Driver")) {
                        PostgreSQLDriverService posrgres = ServiceFactory.getPostgreSQLDriverService(true);
                        con = posrgres.connect(this.info.getURL(), p);
                    } else {
                        con = d.connect(this.info.getURL(), p);
                    }
                } else {
                    con = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                        @Override
                        public Connection run() throws SQLException {
                            return DriverManager.getConnection(JDBCPool.this.info.getURL(), username, password);
                        }
                    }, null, this.getPermissions()) : DriverManager.getConnection(this.info.getURL(), username, password);
                }
                try {
                    con.setTransactionIsolation(this.info.getIntIsolationLevel());
                }
                catch (Exception p) {
                    // empty catch block
                }
                if (this.info.getInitialConnectionSql() == null) break block32;
                try {
                    Statement s = con.createStatement();
                    s.execute(this.info.getInitialConnectionSql());
                    s.close();
                }
                catch (SQLException sqe) {
                    throw new RuntimeException("Init SQL Suffered a SQLException: " + sqe);
                }
            }
            catch (ServiceFactory.ModuleNotAvailableException | ClassNotFoundException cnfex) {
                String url = this.info.getURL();
                String dbDriverName = "";
                String[] urlSplits = url.split(":");
                if (url.startsWith("jdbc:macromedia") && urlSplits.length > 2) {
                    dbDriverName = urlSplits[2];
                } else if (url.startsWith("jdbc:") && urlSplits.length > 1) {
                    dbDriverName = urlSplits[1];
                }
                System.err.println(RB.getString((Object)this, "JDBCPool.noDriverFound", (Object)this.info.getDbname()));
                System.err.println(cnfex.getMessage());
                String dbDriverModuleName = MacromediaDriver.driverNamesMapping.get(dbDriverName);
                if (dbDriverModuleName == null) {
                    dbDriverModuleName = dbDriverName;
                }
                if (MacromediaDriver.driverNamesMapping.containsKey(dbDriverName)) {
                    String scriptName = "cfpm.bat";
                    if (!SystemInfo.isWindows()) {
                        scriptName = "cfpm.sh";
                    }
                    String scriptPath = ServiceFactory.getRuntimeService().getRootDir().replace("\\", "/") + "/bin/" + scriptName;
                    throw new SQLException(RB.getString((Object)this, "JDBCPool.noDriverFound", (Object)this.info.getDbname(), (Object)RB.getString((Object)this, "JDBCPool.noModule", (Object)dbDriverModuleName, (Object)scriptPath)));
                }
                throw new SQLException(RB.getString((Object)this, "JDBCPool.noDriverFoundNonModules", (Object)this.info.getDbname()));
            }
            catch (SQLException sqlex) {
                String emesg = RB.getString((Object)this, "JDBCPool.driverError", (Object)sqlex.toString());
                System.err.println(emesg);
                System.err.println(sqlex.getMessage());
                throw sqlex;
            }
            catch (PrivilegedActionException pEx) {
                String errMessg = pEx.getException().getMessage();
                System.err.println(errMessg);
                throw new SQLException(errMessg);
            }
            catch (DriverNotSupportedException dEx) {
                System.err.println(dEx.getMessage());
                throw dEx;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                throw new SQLException(e.getMessage());
            }
        }
        return con;
    }

    public boolean validateJRunConnection(JRunConnection jcon) {
        return this.validate(jcon);
    }

    protected Permission[] getPermissions() {
        FilePermission webInfPerm = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getWebInfClassesReadPermission();
        if (this.info.getURL().startsWith("jdbc:macromedia:sqlserver://")) {
            return new Permission[]{SQL_SERVER_NAMED_INSTANCE_ACCEPT_PERMISSION, webInfPerm};
        }
        return new Permission[]{webInfPerm};
    }

    protected boolean matchSecurityInfo(String username, String password, Object conn) {
        boolean matched = false;
        JRunConnection pcon = (JRunConnection)conn;
        if (username != null && password != null && username.equals(pcon.getUsername()) && password.equals(pcon.getPassword())) {
            matched = true;
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean validate(Object o) {
        boolean valid = false;
        JRunConnection pcon = (JRunConnection)o;
        try {
            if (!pcon.isConnectionError() && !pcon.getPhysicalConnection().isClosed()) {
                valid = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (valid && this.info.getValidateConnection()) {
            if (pcon.isJDBC4Supported()) {
                valid = pcon.isValid(10);
            } else if (this.info.getValidationQuery() != null && !this.info.getValidationQuery().equals("")) {
                valid = false;
                Connection con = null;
                Statement vs = null;
                ResultSet rs = null;
                try {
                    con = pcon.getPhysicalConnection();
                    vs = con.createStatement();
                    vs.setQueryTimeout(10);
                    vs.execute(this.info.getValidationQuery());
                    valid = true;
                }
                catch (Exception exception) {
                    JDBCPool.closeResources(vs, rs);
                    catch (Throwable throwable) {
                        JDBCPool.closeResources(vs, rs);
                        throw throwable;
                    }
                }
                JDBCPool.closeResources(vs, rs);
            }
        }
        return valid;
    }

    @Override
    protected void expire(Object o) {
        try {
            JRunConnection pcon = (JRunConnection)o;
            pcon.removeConnectionEventListener(this);
            pcon.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        o = null;
    }

    @Override
    public void closeConnection(Object o) {
        try {
            JRunConnection pcon = (JRunConnection)o;
            pcon.removeConnectionEventListener(this);
            pcon.getPhysicalConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        o = null;
    }

    public Connection requestConnection() throws SQLException {
        try {
            JRunConnection pcon = (JRunConnection)this.checkOut(this.info.getUserName(), this.info.isEncrypted() ? this.encrypter.decrypt(this.info.getPassword()) : this.info.getPassword());
            return pcon.getConnection();
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
            throw sqle;
        }
        catch (Exception e) {
            System.err.println(RB.getString((Object)this, "JDBCPool.nonSQLError", (Object)this.info.getDbname()));
            System.err.println(e.getMessage());
            SQLException se = new SQLException(e.getMessage());
            throw se;
        }
    }

    public Connection requestConnection(String username, String password) throws SQLException, DriverNotSupportedException {
        try {
            JRunConnection pcon = (JRunConnection)this.checkOut(username, password);
            return pcon.getConnection();
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
            throw sqle;
        }
        catch (DriverNotSupportedException dnse) {
            System.err.println(dnse.getMessage());
            throw dnse;
        }
        catch (Throwable e) {
            System.err.println(RB.getString((Object)this, "JDBCPool.nonSQLError", (Object)this.info.getDbname()));
            System.err.println(e.getMessage());
            throw new SQLException(e.getMessage());
        }
    }

    public void returnConnection(JRunConnection pcon) {
        if (pcon.clean()) {
            this.checkIn(pcon);
        }
        this.reapStatementRefQeue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement requestPooledStatement(PooledStatementKey poolKey, Connection physCon) {
        ArrayList statements = (ArrayList)this.preparedStatementPool.get(poolKey);
        if (statements != null && statements.size() > 0) {
            ArrayList arrayList = statements;
            synchronized (arrayList) {
                int size;
                for (int i = size = statements.size(); i > 0; --i) {
                    Reference ref = (Reference)statements.get(i - 1);
                    PreparedStatement preparedStatement = (PreparedStatement)ref.get();
                    try {
                        if (preparedStatement == null || preparedStatement.getConnection() != physCon) continue;
                        preparedStatement.clearParameters();
                        statements.remove(ref);
                        return preparedStatement;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnPooledStatement(JRunPreparedStatement ps) {
        if (this.info.getPoolStatements() && ps.getPoolKey() != null) {
            PreparedStatement nativePreparedStmt = ps.getNativePreparedStatement();
            ArrayList<StatementSoftRef> statements = (ArrayList<StatementSoftRef>)this.preparedStatementPool.get(ps.getPoolKey());
            if (statements == null) {
                statements = new ArrayList<StatementSoftRef>();
            }
            ArrayList<StatementSoftRef> arrayList = statements;
            synchronized (arrayList) {
                StatementSoftRef ref = new StatementSoftRef(nativePreparedStmt, this.refQ, ps.getPoolKey());
                statements.add(ref);
                this.preparedStatementPool.put(ps.getPoolKey(), statements);
            }
        } else {
            JDBCPool.closeStatement(ps.getNativePreparedStatement());
        }
    }

    public void cleanPooledStatements(Connection con) throws SQLException {
        if (!this.info.getPoolStatements()) {
            return;
        }
        Object[] prepStatementSets = this.preparedStatementPool.values().toArray();
        int setLength = prepStatementSets.length;
        for (int i = 0; i < setLength; ++i) {
            ArrayList statementList = (ArrayList)prepStatementSets[i];
            ArrayList statementListCopy = new ArrayList(statementList);
            int listLength = statementListCopy.size();
            for (int n = 0; n < listLength; ++n) {
                Reference ref = (Reference)statementList.get(n);
                PreparedStatement ps = (PreparedStatement)ref.get();
                if (ps != null) {
                    Connection thisCon = null;
                    try {
                        thisCon = ps.getConnection();
                    }
                    catch (SQLException e) {
                        System.err.println(RB.getString(JDBCPool.class, "JDBCPool.errorCleaningStatementPool", (Object)this.getPoolname()) + " " + e.getMessage());
                        throw e;
                    }
                    if (!con.equals(thisCon)) continue;
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    statementList.remove(ref);
                    continue;
                }
                statementList.remove(ref);
            }
            statementListCopy.clear();
        }
    }

    private void reapStatementRefQeue() {
        StatementSoftRef ref;
        if (!this.info.getPoolStatements()) {
            return;
        }
        while ((ref = (StatementSoftRef)this.refQ.poll()) != null) {
            PreparedStatement pstmt = (PreparedStatement)ref.get();
            if (pstmt == null) continue;
            List list = (List)this.preparedStatementPool.get(ref.getKey());
            if (list != null) {
                list.remove(ref);
            }
            try {
                pstmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public int numStatementPools() {
        return this.preparedStatementPool.size();
    }

    public int numPooledStatements(String sql) {
        PooledStatementKey key = new PooledStatementKey(sql);
        ArrayList statements = (ArrayList)this.preparedStatementPool.get(key);
        return statements != null ? statements.size() : 0;
    }

    @Override
    public void closeAllResources() {
        this.undeployDataSource();
        super.closeAllResources();
    }

    public static void closeResources(Connection con, Statement statement, ResultSet resultset) {
        JDBCPool.closeResultSet(resultset);
        JDBCPool.closeStatement(statement);
        JDBCPool.closeConnection(con);
    }

    public static void closeResources(Statement statement, ResultSet resultSet) {
        JDBCPool.closeResultSet(resultSet);
        JDBCPool.closeStatement(statement);
    }

    public static void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static class StatementSoftRef
    extends SoftReference {
        private Object key;

        public StatementSoftRef(Object referent, ReferenceQueue q, Object key) {
            super(referent, q);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

