/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql.pool;

import coldfusion.server.j2ee.pool.PoolMetaData;
import coldfusion.server.j2ee.sql.SQLConstants;
import coldfusion.server.j2ee.sql.pool.PoolMetaDataException;
import coldfusion.server.j2ee.sql.pool.TwoFishCryptor;
import coldfusion.util.RB;

public class JDBCPoolMetaData
extends PoolMetaData {
    private String driver;
    private String url;
    private String username;
    private String password;
    private boolean encrypted = false;
    private String encryptionClass = null;
    private boolean nativeResults = false;
    private String validationQuery;
    private boolean validateConnection = false;
    private String initialPoolSql;
    private String initialConnectionSql;
    private boolean removeOnExceptions = true;
    private boolean poolStatements = true;
    private int initialConnections = 1;
    private int connectionTimeout = 1200;
    private int poolRetry = 10;
    private String txdomain = SQLConstants.DEFAULT_TX_DOMAIN;
    private int transactionTimeout = 20;
    private String isolationLevel = this.convertIsoToString(2);
    private boolean cacheEnabled = false;
    private int cacheSize = 5;
    private int cacheRefreshInterval = 30;
    private String jndiName;
    private String description;
    private transient boolean passwordModified = false;

    public void init() {
        super.setInitialObjects(this.initialConnections);
        super.setObjectTimeout(this.connectionTimeout);
        if (this.passwordModified && this.isEncrypted()) {
            this.encryptPassword();
        }
        this.passwordModified = false;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUserName() {
        if (this.username == null) {
            this.username = "";
        }
        return this.username;
    }

    public void setPoolRetry(int i) {
        this.poolRetry = i;
    }

    public int getPoolRetry() {
        return this.poolRetry;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = "";
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.passwordModified = true;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encryption) {
        this.encrypted = encryption;
    }

    public String getEncryptionClass() {
        return this.encryptionClass;
    }

    public void setEncryptionClass(String encryptionClass) {
        this.encryptionClass = encryptionClass;
    }

    public String getDbname() {
        return this.getName();
    }

    public void setDbname(String n) {
        this.setName(n);
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public boolean isNativeResults() {
        return this.nativeResults;
    }

    public void setNativeResults(boolean b) {
        this.nativeResults = b;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String sql) {
        this.validationQuery = sql;
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public String getInitialPoolSql() {
        return this.initialPoolSql;
    }

    public void setInitialPoolSql(String sql) {
        this.initialPoolSql = sql;
    }

    public String getInitialConnectionSql() {
        return this.initialConnectionSql;
    }

    public void setInitialConnectionSql(String sql) {
        this.initialConnectionSql = sql;
    }

    public boolean isRemoveOnExceptions() {
        return this.removeOnExceptions;
    }

    public void setRemoveOnExceptions(boolean b) {
        this.removeOnExceptions = b;
    }

    public int getInitialConnections() {
        return this.getInitialObjects();
    }

    public void setInitialConnections(int n) {
        this.initialConnections = n;
        this.setInitialObjects(n);
    }

    public int getConnectionTimeout() {
        return this.getObjectTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
        this.setObjectTimeout(n);
    }

    public boolean getPoolStatements() {
        return this.poolStatements;
    }

    public void setPoolStatements(boolean b) {
        this.poolStatements = b;
    }

    public String getTransactionDomain() {
        return this.txdomain;
    }

    public void setTransactionDomain(String dn) {
        this.txdomain = dn;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int n) {
        this.transactionTimeout = n;
    }

    public int getIntIsolationLevel() throws PoolMetaDataException {
        return this.convertIsoToInt(this.isolationLevel);
    }

    public void setIntIsolationLevel(int n) {
        this.isolationLevel = this.convertIsoToString(n);
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String s) {
        this.isolationLevel = s;
    }

    private int convertIsoToInt(String s) throws PoolMetaDataException {
        int n = 2;
        if (s != null) {
            if ((s = s.toUpperCase().trim()).equals("NONE")) {
                n = 0;
            } else if (s.equals("READ_COMMITTED")) {
                n = 2;
            } else if (s.equals("READ_UNCOMMITTED")) {
                n = 1;
            } else if (s.equals("REPEATABLE_READ")) {
                n = 4;
            } else if (s.equals("SERIALIZABLE")) {
                n = 8;
            } else {
                String message = RB.getString(JDBCPoolMetaData.class, "JDBCPoolMetaData.badiso", (Object)s, (Object)this.convertIsoToString(n));
                throw new PoolMetaDataException(message);
            }
        }
        return n;
    }

    private String convertIsoToString(int n) {
        String result = null;
        switch (n) {
            case 0: {
                result = "NONE";
                break;
            }
            case 2: {
                result = "READ_COMMITTED";
                break;
            }
            case 1: {
                result = "READ_UNCOMMITTED";
                break;
            }
            case 4: {
                result = "REPEATABLE_READ";
                break;
            }
            case 8: {
                result = "SERIALIZABLE";
                break;
            }
        }
        return result;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheRefreshInterval() {
        return this.cacheRefreshInterval;
    }

    public void setCacheRefreshInterval(int seconds) {
        this.cacheRefreshInterval = seconds;
    }

    private void encryptPassword() {
        String rawPassword = this.getPassword();
        if (rawPassword != null && rawPassword.length() > 0) {
            try {
                String encPassword;
                TwoFishCryptor encrypter = new TwoFishCryptor();
                this.password = encPassword = encrypter.encrypt(this.getPassword());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

