/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.jrun4.metrics;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.tools.CfstatConstants;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.RB;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class CfstatServer
extends Thread
implements CfstatConstants {
    private ServerSocket server;
    private Logger logger;
    private List handlers;
    private Boolean bStopServer = Boolean.FALSE;
    private int cfstatport = 7989;
    private InetAddress inetAddr = null;

    public int getCfstatport() {
        return this.cfstatport;
    }

    public void setCfstatport(int port) {
        if (port != 0) {
            this.cfstatport = port;
        }
    }

    @Override
    public void start() {
        this.handlers = new ArrayList();
        this.logger = ServiceFactory.getLoggingService().getLogger(this.getClass().getName());
        this.bStopServer = Boolean.FALSE;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        Boolean bl = this.bStopServer;
        synchronized (bl) {
            this.bStopServer = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server = new ServerSocket(this.getCfstatport(), 50, this.getCfstatInetAddr());
            while (!this.bStopServer.booleanValue()) {
                Socket incoming = this.server.accept();
                String ip = incoming.getInetAddress().getHostAddress();
                int status = IPAddressUtils.isLocalHost(ip) ? 1 : -1;
                Thread handler = new CfstatHandler(incoming, status);
                this.handlers.add(handler);
                handler.start();
            }
        }
        catch (Exception ioe) {
            this.logger.info(ioe);
        }
        finally {
            while (!this.handlers.isEmpty()) {
                Thread handler = (Thread)this.handlers.remove(0);
                this.stopServer();
                try {
                    this.server.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public InetAddress getCfstatInetAddr() {
        return this.inetAddr;
    }

    public boolean setCfstatInetAddr(String host) throws UnknownHostException {
        boolean changed = false;
        try {
            InetAddress newInetAddr = InetAddress.getByName(host);
            if (!newInetAddr.equals(this.inetAddr)) {
                changed = true;
                this.inetAddr = newInetAddr;
            }
        }
        catch (UnknownHostException e) {
            this.inetAddr = InetAddress.getLocalHost();
            CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "InvalidHost", (Object)host));
            throw e;
        }
        return changed;
    }

    class CfstatHandler
    extends Thread {
        private Socket incoming;
        private int status;

        public CfstatHandler(Socket incoming, int status) {
            this.incoming = incoming;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ApplicationException error = null;
            if (this.status == -1) {
                error = new UnauthorizedConnectionException();
            }
            try {
                this.incoming.setSoTimeout(120000);
                ObjectInputStream in = new ObjectInputStream(this.incoming.getInputStream());
                ObjectOutputStream out = new ObjectOutputStream(this.incoming.getOutputStream());
                block20: while (!CfstatServer.this.bStopServer.booleanValue()) {
                    if (this.status == -1 && error != null) {
                        out.writeInt(-1);
                        String msg = error.getMessage() + error.getDetail();
                        out.writeUTF(msg);
                        out.flush();
                        break;
                    }
                    int cmd = in.readInt();
                    switch (cmd) {
                        case 4: {
                            out.writeInt(this.status);
                            out.writeInt(4);
                            out.flush();
                            continue block20;
                        }
                        case 2: {
                            out.writeInt(this.status);
                            out.writeObject(ServiceFactory.getMetricsService().getSnapshot());
                            out.flush();
                            continue block20;
                        }
                    }
                    this.status = -1;
                    error = new InvalidCommandException();
                }
            }
            catch (SocketException socketException) {
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    this.incoming.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class InvalidCommandException
    extends ApplicationException {
    }

    public static class UnauthorizedConnectionException
    extends ApplicationException {
    }
}

