/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.jrun4.metrics;

import coldfusion.server.Metric;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.tomcat.metrics.Metrics;

public class SimpleLoadMetric
extends ServiceBase
implements Metric,
Runnable {
    private Metrics mm;
    private int maxRequests;
    private long sampleRate;
    private final int MAX_SAMPLE_SIZE = 100;
    private int sampleSize;
    private int constLoad;
    private int sampleIndex;
    private int[] loadSamples;
    private int simpleLoad;
    private SchedulerService ss;

    public SimpleLoadMetric(Metrics mm) {
        this.mm = mm;
        this.loadSamples = new int[100];
        this.ss = ServiceFactory.getSchedulerService();
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate * 1000;
        if (this.sampleRate == 0L) {
            this.sampleRate = 500L;
        }
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
        if (sampleSize > 100) {
            this.sampleSize = 100;
        }
        if (this.sampleSize == 0) {
            sampleSize = 1;
        }
    }

    public void setConstLoad(int constLoad) {
        this.constLoad = constLoad;
        if (this.constLoad > 100 || this.constLoad == 0) {
            this.constLoad = 100;
        }
    }

    @Override
    public String getMetricName() {
        return "SIMPLE_LOAD";
    }

    @Override
    public Object getMetricValue() {
        return this.simpleLoad;
    }

    public long getInterval() {
        return this.sampleRate;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        this.ss.schedule(this, System.currentTimeMillis());
    }

    @Override
    public void run() {
        double loadRunningDelta = (double)this.constLoad / (double)this.maxRequests;
        double loadPendingDelta = loadRunningDelta / 2.0;
        int numRunning = 0;
        int numPending = 0;
        if (this.mm.getMetric("currentThreadsBusy") != null && this.mm.getMetric("currentThreadCount") != null) {
            numRunning = (Integer)this.mm.getMetric("currentThreadsBusy");
            int load = (int)Math.floor(loadRunningDelta * (double)numRunning + loadPendingDelta * (double)(numPending = ((Integer)this.mm.getMetric("currentThreadCount")).intValue()));
            if (load > 100) {
                load = 100;
            }
            this.loadSamples[this.sampleIndex] = load;
            if (++this.sampleIndex >= this.sampleSize) {
                this.sampleIndex = 0;
            }
            int totalLoad = 0;
            for (int i = 0; i < this.sampleSize; ++i) {
                totalLoad += this.loadSamples[i];
            }
            this.simpleLoad = (int)Math.floor((double)totalLoad / (double)this.sampleSize);
        } else {
            this.simpleLoad = 0;
        }
        this.ss.schedule(this, System.currentTimeMillis() + this.sampleRate);
    }

    @Override
    public void stop() throws ServiceException {
        this.ss.cancel(this);
        super.stop();
    }
}

