/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.proxy;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.server.CFService;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyManager {
    private static ProxyManager INSTANCE = null;
    private Logger logger = CFLogs.SERVER_LOG;
    private static final String PROXY = "proxy";
    private static final String PROXY_HOSTNAME = "hostname";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USER = "username";
    private static final String PROXY_PASSWORD = "password";
    private static final String UPDATES_XML_FILE = "neo_updates.xml";
    private ProxyServerDetails proxyServerDetails = new ProxyServerDetails();

    private ProxyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProxyManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ProxyManager> clazz = ProxyManager.class;
        synchronized (ProxyManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ProxyManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public ProxyServerDetails getProxyServerDetails() {
        if (this.proxyServerDetails.getProxyHost() != null) {
            return this.proxyServerDetails;
        }
        this.loadProxySettingsFromJVM();
        if (this.proxyServerDetails.getProxyHost() == null) {
            this.loadProxySettingsFromUpdatesXml();
        }
        return this.proxyServerDetails;
    }

    private void loadProxySettingsFromJVM() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPortValue = System.getProperty("http.proxyPort");
        String proxyUsername = System.getProperty("http.proxyUser");
        String proxyPassword = System.getProperty("http.proxyPassword");
        Integer proxyPort = 80;
        try {
            proxyPort = Integer.parseInt(proxyPortValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.proxyServerDetails.setProxyHost(proxyHost);
        this.proxyServerDetails.setProxyPort(proxyPort);
        this.proxyServerDetails.setProxyUsername(proxyUsername);
        this.proxyServerDetails.setProxyPassword(proxyPassword);
    }

    private void loadProxySettingsFromUpdatesXml() {
        if (System.getSecurityManager() == null) {
            this._loadProxySettingsFromUpdatesXml();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ProxyManager.this._loadProxySettingsFromUpdatesXml();
                    return null;
                }
            });
        }
    }

    private void _loadProxySettingsFromUpdatesXml() {
        String rootDir = CFService.getRoot();
        File updateSettingsFile = new File(rootDir + File.separator + "lib" + File.separator + UPDATES_XML_FILE);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(updateSettingsFile);
            NodeList nodeList = doc.getElementsByTagName("update");
            Node node = null;
            nodeList = doc.getElementsByTagName(PROXY);
            if (nodeList != null) {
                String port;
                nodeList = doc.getElementsByTagName(PROXY_HOSTNAME);
                if (nodeList != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    this.proxyServerDetails.setProxyHost(node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_PORT)) != null && (node = nodeList.item(0)).getFirstChild() != null && (port = node.getFirstChild().getNodeValue()) != null && port.length() > 0) {
                    this.proxyServerDetails.setProxyPort(Integer.parseInt(node.getFirstChild().getNodeValue()));
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_USER)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    this.proxyServerDetails.setProxyUsername(node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_PASSWORD)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    this.proxyServerDetails.setProxyPassword(node.getFirstChild().getNodeValue());
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("An error has occurred while reading proxy server details from neo_updates.xml file.", ex);
        }
    }

    public class ProxyServerDetails {
        private String proxyHost = null;
        private Integer proxyPort;
        private String proxyUsername = null;
        private String proxyPassword = null;

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
        }

        public String getProxyUsername() {
            return this.proxyUsername;
        }

        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }

        public String getProxyPassword() {
            return this.proxyPassword;
        }
    }
}

