/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.serverless;

import coldfusion.serverless.InMemoryFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class InMemoryInputStream
extends InputStream {
    private InMemoryFile inMemoryFile;

    public InMemoryInputStream(InMemoryFile inmMemoryFile) {
        this.inMemoryFile = inmMemoryFile;
    }

    @Override
    public int available() {
        return this.inMemoryFile.size();
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        int read = this.read(data);
        if (read == -1) {
            return read;
        }
        return data[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] contents = this.inMemoryFile.read();
        b = new byte[contents.length];
        b = Arrays.copyOf(contents, contents.length);
        return contents.length;
    }

    public byte[] readBytes() {
        return this.inMemoryFile.contents;
    }
}

