/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.osgi.services.DDDatabaseService;
import coldfusion.runtime.DatabaseException;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.IDataSourceManager;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class CFDataSource
implements DataSource {
    static final String SQLSERVER_DRIVER = "macromedia.jdbc.sqlserver.SQLServerDriver";
    static final String DB2_DRIVER = "macromedia.jdbc.db2.DB2Driver";
    static final String INFORMIX_DRIVER = "macromedia.jdbc.informix.InformixDriver";
    static final String ORACLE_DRIVER = "macromedia.jdbc.oracle.OracleDriver";
    static final String MYSQL_DRIVER = "macromedia.jdbc.mysql.MySQLDriver";
    static final String SEQUELINK_DRIVER = "macromedia.jdbc.sequelink.SequeLinkDriver";
    static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private DataSource _ds = null;
    private static String OEMID = "";
    private boolean disabled = false;
    private IDataSourceManager _mymanager;
    private DataSourceDef _def;

    public CFDataSource(DataSource ds) {
        this._ds = ds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        DDDatabaseService ddDatabaseService;
        String u;
        if (this.disabled) {
            throw new DataSourceDisabledException(this._def.getDsn());
        }
        Connection con = null;
        if (this._def != null && (u = this._def.getUsername()) != null && u.length() > 0) {
            con = this._ds.getConnection(u, this._def.getPassword());
        }
        if (this._def.getClassName() != null) {
            switch (this._def.getClassName()) {
                case "macromedia.jdbc.sqlserver.SQLServerDriver": {
                    ServiceFactory.getSqlServerDriverService(true);
                    break;
                }
                case "macromedia.jdbc.db2.DB2Driver": {
                    ServiceFactory.getDb2DriverService(true);
                    break;
                }
                case "macromedia.jdbc.informix.InformixDriver": {
                    ServiceFactory.getInformixDriverService(true);
                    break;
                }
                case "macromedia.jdbc.oracle.OracleDriver": {
                    ServiceFactory.getOracleDriverService(true);
                    break;
                }
                case "macromedia.jdbc.mysql.MySQLDriver": {
                    ServiceFactory.getMySQLDriverService(true);
                    break;
                }
                case "macromedia.jdbc.sequelink.SequeLinkDriver": {
                    ServiceFactory.getSequelinkService(true);
                    break;
                }
                case "org.apache.derby.jdbc.EmbeddedDriver": {
                    ServiceFactory.getApacheDerbyService(true);
                    break;
                }
                case "org.postgresql.Driver": {
                    ServiceFactory.getPostgreSQLDriverService(true);
                }
            }
        }
        if (con == null) {
            con = this._ds.getConnection();
        }
        if ((ddDatabaseService = ServiceFactory.getDdDatabaseService()) != null && ddDatabaseService.isInstanceOfExtEmbeddedConnection(con)) {
            ddDatabaseService.ulockExtEmbeddedConnection(con);
        }
        return con;
    }

    @Override
    public Connection getConnection(String s, String s1) throws SQLException {
        if (this.disabled) {
            throw new DataSourceDisabledException(this._def.getDsn());
        }
        Connection con = this._ds.getConnection(s, s1);
        DDDatabaseService ddDatabaseService = ServiceFactory.getDdDatabaseService();
        if (ddDatabaseService != null && ddDatabaseService.isInstanceOfExtEmbeddedConnection(con)) {
            ddDatabaseService.ulockExtEmbeddedConnection(con);
        }
        return con;
    }

    protected void setDataSourceManager(IDataSourceManager dm) {
        this._mymanager = dm;
    }

    public void remove() throws SQLException {
        if (this._mymanager == null) {
            throw new SQLException("Datasource remove operation failed - no DatasourceManager available");
        }
        this._mymanager.removeDatasource(this._def);
    }

    public void setDataSourceDef(DataSourceDef def) {
        this._def = def;
    }

    public DataSourceDef getDataSourceDef() {
        return this._def;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._ds.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._ds.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this._ds.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int i) throws SQLException {
        this._ds.setLoginTimeout(i);
    }

    public static void setOEMID(String id) {
        OEMID = id;
    }

    public static String getOEMID() {
        return OEMID;
    }

    public String toString() {
        return "remote host = " + this._def.getHost();
    }

    protected void setDisabled(boolean dis) {
        this.disabled = dis;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isWrapperFor(Class<?> c) {
        throw new UnsupportedOperationException("Wrapper.isWrapperFor(java.lang.Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException("Wrapper.unwrap(Class<T> iface)");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public static class DataSourceDisabledException
    extends DatabaseException {
        public String dsn;

        protected DataSourceDisabledException(String dsn) {
            this.dsn = dsn;
        }

        public String getDsn() {
            return this.dsn;
        }
    }
}

