/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.j2ee.sql.pool.JDBCManager;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import coldfusion.server.j2ee.sql.pool.JDBCPoolMetaData;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.IDataSourceManager;
import coldfusion.sql.JNDIUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.sql.DataSource;

public class CFPooledDataSource
implements IDataSourceManager {
    @Override
    public List getNames() throws Exception {
        Enumeration poolnamesEnum = JDBCManager.getInstance().getAllPoolnames();
        ArrayList ls = new ArrayList();
        while (poolnamesEnum.hasMoreElements()) {
            ls.add(poolnamesEnum.nextElement());
        }
        return ls;
    }

    private void addToMap(Map dsList, Class cls, String name, String dir) {
        if (DataSource.class.isAssignableFrom(cls)) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("ISJ2EE", Boolean.TRUE);
            m.put("name", name);
            m.put("jndiDir", dir);
            dsList.put(name, m);
        }
    }

    private void processEnum(Context ctx, Map dsList, String directory) throws Exception {
        try {
            Class.forName("com.ibm.ws.bootstrap.WSLauncher");
            NamingEnumeration<Binding> bindingsEnum = ctx.listBindings(directory);
            while (bindingsEnum.hasMoreElements()) {
                Binding bind = (Binding)bindingsEnum.nextElement();
                if (bind == null) continue;
                try {
                    Object obj = bind.getObject();
                    if (obj == null) continue;
                    Class<?> cls = obj.getClass();
                    this.addToMap(dsList, cls, bind.getName(), directory);
                }
                catch (Exception obj) {}
            }
            return;
        }
        catch (ClassNotFoundException bind) {
            try {
                NamingEnumeration<NameClassPair> bindingsEnum = ctx.list(directory);
                while (bindingsEnum.hasMoreElements()) {
                    NameClassPair np = (NameClassPair)bindingsEnum.nextElement();
                    String name = np.getName();
                    Object oj = ctx.lookup(directory + "/" + name);
                    if (oj.getClass().getName().equals("com.sun.enterprise.resource.SystemJdbcDataSource")) continue;
                    this.addToMap(dsList, oj.getClass(), name, directory);
                }
                return;
            }
            catch (Throwable err) {
                if (directory.equals("")) {
                    try {
                        NamingEnumeration<NameClassPair> bindingsEnum = ctx.list(directory);
                        while (bindingsEnum.hasMoreElements()) {
                            NameClassPair np = (NameClassPair)bindingsEnum.nextElement();
                            String name = np.getName();
                            Object oj = ctx.lookup(name);
                            if (oj.getClass().getName().equals("com.sun.enterprise.resource.SystemJdbcDataSource")) continue;
                            this.addToMap(dsList, oj.getClass(), name, directory);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getJ2eeDataSources() throws Exception {
        Struct dsList = new Struct();
        String dir = null;
        try (InitialContext ctx = null;){
            ctx = new InitialContext();
            try {
                dir = "/";
                this.processEnum(ctx, dsList, dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dir = "";
                this.processEnum(ctx, dsList, dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dir = "jdbc";
                this.processEnum(ctx, dsList, dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dir = "java:comp/env/jdbc";
                this.processEnum(ctx, dsList, dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dsList;
    }

    /*
     * Loose catch block
     */
    @Override
    public DataSource getDataSource(String dsn) {
        InitialContext ctx;
        DataSource ds;
        block12: {
            ds = null;
            ctx = null;
            try {
                ds = ((JDBCPool)JDBCManager.getInstance().getPool(dsn)).getDataSource();
            }
            catch (Exception e) {
                try {
                    ctx = new InitialContext();
                    ds = (DataSource)ctx.lookup(dsn);
                }
                catch (Throwable t) {
                    Map dsources = this.getJ2eeDataSources();
                    Map mp = (Map)dsources.get(dsn);
                    if (mp != null) {
                        DataSource dataSource;
                        try {
                            String jndiDir = (String)mp.get("jndiDir");
                            Object jndiName = jndiDir.length() == 0 ? dsn : jndiDir + "/" + dsn;
                            dataSource = (DataSource)ctx.lookup((String)jndiName);
                        }
                        catch (Exception exception) {}
                        JNDIUtils.close(ctx);
                        return dataSource;
                    }
                    break block12;
                    {
                        catch (Exception e2) {
                            try {
                                throw new ServiceRuntimeException(e2);
                            }
                            catch (Throwable throwable) {
                                JNDIUtils.close(ctx);
                                throw throwable;
                            }
                        }
                    }
                }
            }
        }
        JNDIUtils.close(ctx);
        return ds;
    }

    @Override
    public CFDataSource newDataSource(DataSourceDef def) throws SQLException {
        DataSource ds = this.setDatasource(def.getDsn(), def.getClassName(), def.getDesc(), def.getUsername(), def.getPassword(), def.getUrl(), def.isPooling(), def.getTimeout(), def.getInterval(), def.getValidationQuery(), def.isValidateConnection(), def.getExtraData(), def.isDynamic());
        CFDataSource cfds = new CFDataSource(ds);
        cfds.setDataSourceDef(def);
        return cfds;
    }

    public void removeDatasource(String dsn) {
        JDBCManager.getInstance().removePool(dsn);
    }

    @Override
    public void removeDatasource(DataSourceDef def) {
        if (def.isDynamic()) {
            this.removeDatasource("app_" + FusionContext.getCurrent().getApplicationName() + def.getDsn());
        } else {
            this.removeDatasource(def.getDsn());
        }
    }

    public DataSource setDatasource(String dsn, String className, String description, String username, String password, String url, boolean pooling, int timeout, int interval, String validationQuery, boolean validateConnection, Map extraData) throws SQLException {
        return this.setDatasource(dsn, className, description, username, password, url, pooling, timeout, interval, validationQuery, validateConnection, extraData, false);
    }

    public DataSource setDatasource(String dsn, String className, String description, String username, String password, String url, boolean pooling, int timeout, int interval, String validationQuery, boolean validateConnection, Map extraData, boolean appDataSource) throws SQLException {
        int lto = 10;
        JDBCPoolMetaData md = new JDBCPoolMetaData();
        md.setDriver(className);
        md.setJNDIName("coldfusion/datasource/" + dsn);
        if (appDataSource) {
            md.setName("app_" + FusionContext.getCurrent().getApplicationName() + "_" + dsn);
        } else {
            md.setName(dsn);
        }
        md.setEncrypted(true);
        md.setPassword(password);
        md.setURL(url);
        md.setUserName(username);
        md.setSkimmerFrequency(interval);
        md.setDescription(description);
        md.setValidationQuery(validationQuery);
        md.setValidateConnection(validateConnection);
        if (extraData != null) {
            Integer lTimeOut;
            String maxConnections = (String)extraData.get("maxconnections");
            if (maxConnections != null) {
                int i = Integer.parseInt(maxConnections);
                md.setMaximumSize(i);
            }
            if ((lTimeOut = (Integer)extraData.get("_logintimeout")) != null) {
                lto = lTimeOut;
            }
        }
        md.setNativeResults(true);
        md.setInitialConnections(0);
        md.setPoolStatements(false);
        md.setMaximumSoft(false);
        md.setDisablePooling(!pooling);
        md.setConnectionTimeout(timeout);
        md.setTransactionTimeout(timeout);
        md.setSkimmerFrequency(interval);
        md.setPoolRetry(lto);
        if (pooling) {
            md.setRemoveOnExceptions(true);
        } else {
            md.setRemoveOnExceptions(false);
        }
        if (this.exists(md.getDbname())) {
            this.removeDatasource(md.getDbname());
        }
        JDBCPool pool = JDBCManager.getInstance().createPool(md);
        try {
            pool.getDataSource().setLoginTimeout(lto);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return pool.getDataSource();
    }

    public boolean exists(String dsn) {
        try {
            ((JDBCPool)JDBCManager.getInstance().getPool(dsn)).getDataSource();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }
}

