/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.DatabaseException;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.CFPooledDataSource;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.IDataSourceManager;
import coldfusion.sql.J2EEDataSource;
import coldfusion.sql.JNDIUtils;
import coldfusion.util.FastHashtable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceFactory {
    private FastHashtable _datasources = new FastHashtable();
    private FastHashtable _defs = new FastHashtable();
    private static final DataSourceFactory _thisFactory = new DataSourceFactory();
    IDataSourceManager _ddtek;
    IDataSourceManager _cfpool;
    IDataSourceManager _j2ee;

    private DataSourceFactory() {
        this.initManagers();
    }

    private void initManagers() {
        this._cfpool = new CFPooledDataSource();
        this._j2ee = new J2EEDataSource(this.getJNDIenv());
    }

    public static DataSourceFactory getInstance() {
        return _thisFactory;
    }

    CFDataSource getDataSource(String dsn) {
        CFDataSource ds = null;
        try {
            String appName = FusionContext.getCurrent().getApplicationName();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            ds = appScope.getAppDataSource(dsn);
        }
        catch (Exception appName) {
            // empty catch block
        }
        if (ds != null) {
            return ds;
        }
        ds = (CFDataSource)this._datasources.get(dsn);
        Context ctx = null;
        if (ds == null) {
            try {
                ctx = JNDIUtils.getContext(this.getJNDIenv());
                DataSource jds = JNDIUtils.getJNDIDataSource(dsn, ctx);
                if (jds == null) {
                    throw new DataSourceException(dsn);
                }
                ds = new CFDataSource(jds);
            }
            catch (NamingException ne) {
                throw new DataSourceException(dsn);
            }
            finally {
                JNDIUtils.close(ctx);
            }
        }
        return ds;
    }

    DataSourceDef getDataSourceDef(String dsn) {
        return (DataSourceDef)this._defs.get(dsn);
    }

    CFDataSource createDataSource(String dsn, DataSourceDef def) throws SQLException {
        CFDataSource ds = null;
        switch (def.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                ds = this._cfpool.newDataSource(def);
                ds.setDataSourceManager(this._cfpool);
                break;
            }
            case 7: {
                ds = this._j2ee.newDataSource(def);
                ds.setDataSourceManager(this._j2ee);
                break;
            }
            case 6: 
            case 8: {
                ds = this._cfpool.newDataSource(def);
                ds.setDataSourceManager(this._cfpool);
            }
        }
        return ds;
    }

    public CFDataSource setDataSource(String dsn, DataSourceDef def) throws SQLException {
        CFDataSource oldCFds;
        if (!def.isDynamic() && (oldCFds = (CFDataSource)this._datasources.get(dsn)) != null) {
            oldCFds.remove();
        }
        CFDataSource cfds = this.createDataSource(dsn, def);
        if (!def.isDynamic()) {
            this._datasources.put(dsn, (Object)cfds);
            this._defs.put(dsn, (Object)def);
        }
        return cfds;
    }

    void removeDataSource(String dsn) throws SQLException {
        CFDataSource ds = (CFDataSource)this._datasources.get(dsn);
        if (ds != null) {
            ds.remove();
        }
        this._datasources.remove(dsn);
        this._defs.remove(dsn);
    }

    void clear() throws SQLException {
        this._datasources.clear();
        this._defs.clear();
    }

    protected List getDataSourceNames() {
        return new ArrayList(this._datasources.keySet());
    }

    public Hashtable getJNDIenv() {
        return null;
    }

    public static class DataSourceException
    extends DatabaseException {
        public String dsn;

        protected DataSourceException(String dsn) {
            this.dsn = dsn;
        }

        public String getDsn() {
            return this.dsn;
        }
    }
}

