/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.ConnectionSource;
import coldfusion.sql.DataSourcePermission;
import coldfusion.sql.Executive;
import coldfusion.util.RB;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;

public class DataSrcImpl
extends ConnectionSource {
    private static ThreadLocal proxy = new ThreadLocal();
    private String name = null;
    private DataSource ds = null;
    private ArrayList con_cache = new ArrayList();

    public static void clearSqlProxy() {
        Object obj = proxy.get();
        if (obj != null) {
            ((DataSrcImpl)obj).clear();
        }
        proxy.remove();
    }

    public static DataSrcImpl getSqlProxy() {
        Object obj = proxy.get();
        if (obj == null) {
            obj = new DataSrcImpl();
            proxy.set(obj);
        }
        return (DataSrcImpl)obj;
    }

    public Object getDatasrc() {
        return this.ds;
    }

    public void setDatasrc(Object obj) {
        if (obj instanceof CFDataSource) {
            this.setDatasrc((CFDataSource)obj);
        } else {
            this.setDatasrc((String)obj);
        }
    }

    public void setDatasrc(String n) {
        this.name = n;
        this.ds = null;
    }

    public void setDatasrc(CFDataSource cfds) {
        this.ds = cfds;
        this.name = cfds.getDataSourceDef().getDsn();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void validate() throws SQLException {
        if (this.name == null) {
            throw new SQLException(RB.getString(this, "DataSrcImpl.1"));
        }
        if (this.ds == null) {
            try {
                this.ds = ((Executive)ServiceFactory.getDataSourceService()).getDatasource1(this.name);
            }
            catch (Throwable t) {
                throw new SQLException(t.getMessage());
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getCachedConnection(this.getUsername(), this.getPassword());
    }

    @Override
    public Connection getConnection(String u, String p) throws SQLException {
        return this.getCachedConnection(u, p);
    }

    private static void check(String dsn) {
        ServiceFactory.getSecurityService().checkPermission(new DataSourcePermission(dsn.toLowerCase()));
    }

    private Connection getCachedConnection(String u, String p) throws SQLException {
        DataSrcImpl.check(this.name);
        if (this.ds instanceof CFDataSource && ServiceFactory.getDataSourceService().disableConnection(this.name)) {
            throw new SQLException(RB.getString(this, "DataSrcImpl.2"));
        }
        int size = this.con_cache.size();
        for (int i = 0; i < size; ++i) {
            ConnectionCache cc = (ConnectionCache)this.con_cache.get(i);
            if (!this.name.equalsIgnoreCase(cc.name) || cc.username != u && (cc.username == null || u == null || !u.equals(cc.username)) || cc.password != p && (cc.password == null || p == null || !p.equals(cc.password))) continue;
            if (!cc.con.isClosed()) {
                return cc.con;
            }
            this.con_cache.remove(i);
            break;
        }
        Connection con = null;
        if (this.ds != null) {
            con = u == null || u.length() == 0 ? this.ds.getConnection() : this.ds.getConnection(u, p);
            this.con_cache.add(new ConnectionCache(this.name, u, p, con, System.currentTimeMillis()));
            return con;
        }
        throw new SQLException(RB.getString(this, "DataSrcImpl.1"));
    }

    @Override
    public void clear() {
        int size = this.con_cache.size();
        for (int i = 0; i < size; ++i) {
            Connection con = ((ConnectionCache)this.con_cache.get((int)i)).con;
            try {
                con.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.con_cache.clear();
        super.clear();
    }

    class ConnectionCache {
        protected String name;
        protected String username;
        protected String password;
        protected Connection con;

        ConnectionCache(String n, String u, String p, Connection c, long time) {
            this.name = n;
            this.username = u;
            this.password = p;
            this.con = c;
        }

        protected Connection getConn() {
            return this.con;
        }
    }
}

